/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.positiveinteger.maxexclusive.maxexclusive_5;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive5_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive5_GetSetCTTests test = new maxExclusive5_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxExclusive-5-1.xml", "maxExclusive-5-2.xml", "maxExclusive-5-3.xml",
            "maxExclusive-5-4.xml", "maxExclusive-5-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("1"), new BigInteger("56011983446624269421"), 
                                       new BigInteger("40279904263516419504"), new BigInteger("84858216762798222008"), 
                                       new BigInteger("99999999999999999998")};
        BigInteger[] anExpectedValues = {new BigInteger("65535"), new BigInteger("1"), new BigInteger("99999999999999999998"), 
                                         new BigInteger("84858216762798222008"), new BigInteger("222222222222222")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("1"), new BigInteger("56011983446624269421"), 
                                  new BigInteger("40279904263516419504"), new BigInteger("84858216762798222008"), 
                                  new BigInteger("99999999999999999998")};
        BigInteger[] anSetValues = {new BigInteger("65535"), new BigInteger("1"), new BigInteger("99999999999999999998"), 
                                    new BigInteger("84858216762798222008"), new BigInteger("222222222222222")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaPositiveIntegerMaxExclusive5(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

