/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.annotation.xmlseealso001;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.UnmarshalException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import javasoft.sqe.tests.api.jakarta.xml.bind.ErrorCollector;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class XmlSeeAlsoCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        XmlSeeAlsoCTTests test = new XmlSeeAlsoCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Document getDocument(String doc)
    			throws ParserConfigurationException, SAXException, IOException {
    		URL documentURL = getDocumentURL(doc);
    		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    		dbf.setNamespaceAware(true);
    		DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
    		return documentBuilder.parse(documentURL.openStream());
    	}
      
    	public Schema getSchema(String schemaName) {
    		Schema schema;
    		ErrorCollector errorHandler;
    		try {
                URL schemaURL = getDocumentURL(schemaName);
    			StreamSource ss = new StreamSource(schemaURL.toExternalForm());
    			SchemaFactory factory = SchemaFactory.newInstance(
                                  javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI);
    			errorHandler = new ErrorCollector();
    			factory.setErrorHandler(errorHandler);
    			schema = factory.newSchema(ss);
    		} catch (Exception e) {
    	          throw new RuntimeException( e );			
    		}
    		if ( errorHandler.hasEvents() ) {
    			ref.println("Schema Compilation: ");
    			errorHandler.printEvents( ref );
                return null;
    		}
    		return schema;
    	}

    public Status TestCase001( ) {
        ErrorCollector eh = new ErrorCollector();
        try {
          JAXBContext jc = JAXBContext.newInstance( javasoft.sqe.tests.api.jakarta.xml.bind.annotation.XmlSeeAlso.data001.XmlSeeAlso001a.class );
          if (jc == null)
            return Status.failed("JAXBContext is null for XmlSeeAlso001a.class");

          Schema schema = getSchema("XmlSeeAlso001.xsd");

          Binder<Node> binder = jc.createBinder();
          Document document = getDocument("XmlSeeAlso001c.xml");

          if ( schema == null ) 
              return Status.failed("Schema compilation of XmlSeeAlso001.xsd failed.");
          
          binder.setSchema(schema);
          try {
            binder.unmarshal(document);
          } catch (UnmarshalException x) {
            x.printStackTrace(ref);
            return Status.failed("Unexpected UnmarshalException was thrown");
          }
        } catch (Exception x) {
          x.printStackTrace( ref );
          return Status.failed("Unexpected exception " + x);
        }
        return Status.passed("OK");
    }


}

