/*
 * Copyright (c) 2007, 2018 Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2002 International Business Machines Corp. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

// Helper class generated by xrpcc, do not edit.
// Contents subject to change without notice.

package com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.marshalltest;

import java.util.Map;
import java.util.HashMap;

public class EnumDouble {
  private double value;

  private static Map valueMap = new HashMap();

  public static final double _value1 = (double) -1.0000000000000;

  public static final double _value2 = (double) 3.0000000000000;

  public static final EnumDouble value1 = new EnumDouble(_value1);

  public static final EnumDouble value2 = new EnumDouble(_value2);

  protected EnumDouble(double value) {
    this.value = value;
    valueMap.put(this.toString(), this);
  }

  public double getValue() {
    return value;
  }

  public static EnumDouble fromValue(double value)
      throws java.lang.IllegalStateException {
    if (value1.value == value) {
      return value1;
    } else if (value2.value == value) {
      return value2;
    }
    throw new IllegalArgumentException();
  }

  public static EnumDouble fromString(String value)
      throws java.lang.IllegalStateException {
    EnumDouble ret = (EnumDouble) valueMap.get(value);
    if (ret != null) {
      return ret;
    }
    if (value.equals("-1.0000000000000")) {
      return value1;
    } else if (value.equals("3.0000000000000")) {
      return value2;
    }
    throw new IllegalArgumentException();
  }

  public String toString() {
    return new Double(value).toString();
  }

  private Object readResolve() throws java.io.ObjectStreamException {
    return fromValue(getValue());
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof EnumDouble)) {
      return false;
    }
    return ((EnumDouble) obj).value == value;
  }

  public int hashCode() {
    return new Double(value).toString().hashCode();
  }
}
