/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.NullStorelessUnivariateStatistic;
import org.eclipse.january.metadata.Dirtiable;
import org.eclipse.january.metadata.StatisticsMetadata;

public class StatisticsMetadataImpl<T>
implements StatisticsMetadata<T> {
    private static final long serialVersionUID = -6660224998596148031L;
    private static final int COMBOS = 4;
    private int hash;
    private int dtype;
    private int isize;
    private Dataset dataset;
    private Dataset[][] axisStats = null;
    private MaxMin<T>[] mms;
    private SummaryStatistics[][] summaries;
    @Dirtiable
    private boolean isDirty = true;
    private static final int AS_MAX = 0;
    private static final int AS_MIN = 1;
    private static final int AS_MAX_INDEX = 2;
    private static final int AS_MIN_INDEX = 3;
    private static final int AS_CNT = 4;
    private static final int AS_MEAN = 5;
    private static final int AS_SUM = 6;
    private static final int AS_VAR = 7;

    public StatisticsMetadataImpl() {
    }

    private StatisticsMetadataImpl(StatisticsMetadataImpl<T> statsMetadata) {
        this.hash = statsMetadata.hash;
        this.isize = statsMetadata.isize;
        this.dtype = statsMetadata.dtype;
        this.dataset = statsMetadata.dataset.getView(false);
        this.axisStats = new Dataset[this.dataset.getRank() * 4][];
        int i = 0;
        while (i < this.axisStats.length) {
            this.axisStats[i] = statsMetadata.axisStats[i];
            ++i;
        }
        if (statsMetadata.mms != null) {
            this.mms = new MaxMin[4];
            i = 0;
            while (i < this.mms.length) {
                this.mms[i] = statsMetadata.mms[i];
                ++i;
            }
        }
        this.summaries = new SummaryStatistics[4][];
        i = 0;
        while (i < this.summaries.length) {
            SummaryStatistics[] oSummary = statsMetadata.summaries[i];
            if (oSummary != null) {
                SummaryStatistics[] nSummary = new SummaryStatistics[this.isize];
                this.summaries[i] = nSummary;
                int j = 0;
                while (j < this.isize) {
                    nSummary[j] = oSummary[j];
                    ++j;
                }
            }
            ++i;
        }
        this.isDirty = statsMetadata.isDirty;
    }

    @Override
    public void initialize(Dataset dataset) {
        this.dataset = dataset.getView(false);
        this.dataset.clearMetadata(null);
        this.dtype = dataset.getDType();
        this.isize = dataset.getElementsPerItem();
        this.mms = new MaxMin[4];
        this.summaries = new SummaryStatistics[4][];
        this.axisStats = new Dataset[this.dataset.getRank() * 4][];
        this.setDirty();
    }

    private int refresh(boolean maxMin, boolean ... ignoreInvalids) {
        int idx;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (this.dataset.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if (this.isDirty) {
            this.clearAll();
        }
        if (this.mms[idx = (ignoreNaNs ? 1 : 0) * 2 + (ignoreInfs ? 1 : 0)] == null) {
            this.mms[idx] = new MaxMin();
        }
        if (maxMin) {
            if (this.mms[idx].maximum == null) {
                this.setMaxMin(this.mms[idx], ignoreNaNs, ignoreInfs);
            }
        } else if (this.summaries[idx] == null) {
            this.summaries[idx] = this.createSummaryStats(this.mms[idx], ignoreNaNs, ignoreInfs);
        }
        this.isDirty = false;
        return idx;
    }

    /*
     * Unable to fully structure code
     */
    private void setMaxMin(MaxMin<T> mm, boolean ignoreNaNs, boolean ignoreInfs) {
        block16: {
            block15: {
                block14: {
                    iter = this.dataset.getIterator();
                    if (!DTypeUtils.isDTypeNumerical(this.dtype)) {
                        smin = smax = this.dataset.getStringAbs(0);
                        while (iter.hasNext()) {
                            val = this.dataset.getStringAbs(iter.index);
                            this.hash = this.hash * 19 + val.hashCode();
                            if (val.compareTo(smax) > 0) {
                                smax = val;
                            }
                            if (val.compareTo(smin) >= 0) continue;
                            smin = val;
                        }
                        this.hash = this.hash * 19 + this.dtype * 17 + this.isize;
                        mm.maximum = smax;
                        mm.minimum = smin;
                        mm.maximumPositions = null;
                        mm.minimumPositions = null;
                        return;
                    }
                    if (this.isize != 1) ** GOTO lbl68
                    amax = -Infinity;
                    amin = Infinity;
                    hasNaNs = false;
                    if (!this.dataset.hasFloatingPointElements() || !ignoreNaNs && !ignoreInfs) break block14;
                    while (iter.hasNext()) {
                        val = this.dataset.getElementDoubleAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                        if (Double.isNaN(val)) {
                            if (ignoreNaNs) continue;
                            hasNaNs = true;
                        } else if (Double.isInfinite(val) && ignoreInfs) continue;
                        if (val > amax) {
                            amax = val;
                        }
                        if (!(val < amin)) continue;
                        amin = val;
                    }
                    break block15;
                }
                if (!this.dataset.hasFloatingPointElements()) ** GOTO lbl57
                while (iter.hasNext()) {
                    val = this.dataset.getElementDoubleAbs(iter.index);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    if (Double.isNaN(val)) {
                        hasNaNs = true;
                        continue;
                    }
                    if (val > amax) {
                        amax = val;
                    }
                    if (!(val < amin)) continue;
                    amin = val;
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    val = this.dataset.getElementLongAbs(iter.index);
                    this.hash = (int)((long)(this.hash * 19) + val);
                    if ((double)val > amax) {
                        amax = val;
                    }
                    if (!((double)val < amin)) continue;
                    amin = val;
lbl57:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            mm.maximum = hasNaNs != false ? Double.valueOf(NaN) : DTypeUtils.fromDoubleToBiggestNumber(amax, this.dtype);
            mm.minimum = hasNaNs != false ? Double.valueOf(NaN) : DTypeUtils.fromDoubleToBiggestNumber(amin, this.dtype);
            break block16;
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < this.isize) {
                    val = this.dataset.getElementDoubleAbs(iter.index + j);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    ++j;
                }
lbl68:
                // 2 sources

                ** while (iter.hasNext())
            }
lbl69:
            // 1 sources

            mm.maximum = null;
            mm.minimum = null;
        }
        this.hash = this.hash * 19 + this.dtype * 17 + this.isize;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
    }

    /*
     * Unable to fully structure code
     */
    private SummaryStatistics[] createSummaryStats(MaxMin<T> mm, boolean ignoreNaNs, boolean ignoreInfs) {
        block16: {
            block13: {
                block15: {
                    block14: {
                        iter = this.dataset.getIterator();
                        istats = new SummaryStatistics[this.isize];
                        i = 0;
                        while (i < this.isize) {
                            istats[i] = new SummaryStatistics();
                            istats[i].setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
                            ++i;
                        }
                        if (this.isize != 1) break block13;
                        hasNaNs = false;
                        stats = istats[0];
                        if (!this.dataset.hasFloatingPointElements() || !ignoreNaNs && !ignoreInfs) break block14;
                        while (iter.hasNext()) {
                            val = this.dataset.getElementDoubleAbs(iter.index);
                            this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                            if (Double.isNaN(val)) {
                                if (ignoreNaNs) continue;
                                hasNaNs = true;
                            } else if (Double.isInfinite(val) && ignoreInfs) continue;
                            stats.addValue(val);
                        }
                        break block15;
                    }
                    if (!this.dataset.hasFloatingPointElements()) ** GOTO lbl37
                    while (iter.hasNext()) {
                        val = this.dataset.getElementDoubleAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                        if (Double.isNaN(val)) {
                            hasNaNs = true;
                        }
                        stats.addValue(val);
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        val = this.dataset.getElementLongAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + val);
                        stats.addValue((double)val);
lbl37:
                        // 2 sources

                        ** while (iter.hasNext())
                    }
                }
                mm.maximum = hasNaNs != false ? Double.valueOf(NaN) : DTypeUtils.fromDoubleToBiggestNumber(stats.getMax(), this.dtype);
                mm.minimum = hasNaNs != false ? Double.valueOf(NaN) : DTypeUtils.fromDoubleToBiggestNumber(stats.getMin(), this.dtype);
                break block16;
            }
            vals = new double[this.isize];
            while (iter.hasNext()) {
                okay = true;
                j = 0;
                while (j < this.isize) {
                    val = this.dataset.getElementDoubleAbs(iter.index + j);
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    vals[j] = val;
                    ++j;
                }
                if (!okay) continue;
                j = 0;
                while (j < this.isize) {
                    val = vals[j];
                    istats[j].addValue(val);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    ++j;
                }
            }
            lmax = new double[this.isize];
            lmin = new double[this.isize];
            j = 0;
            while (j < this.isize) {
                stats = istats[j];
                lmax[j] = stats.getMax();
                lmin[j] = stats.getMin();
                ++j;
            }
            mm.maximum = (T)lmax;
            mm.minimum = (T)lmin;
        }
        this.hash = this.hash * 19 + this.dtype * 17 + this.isize;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
        return istats;
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    private void clearAll() {
        this.hash = 0;
        int i = 0;
        while (i < this.summaries.length) {
            this.summaries[i] = null;
            this.mms[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.axisStats.length) {
            this.axisStats[i] = null;
            ++i;
        }
    }

    @Override
    public StatisticsMetadataImpl<T> clone() {
        return new StatisticsMetadataImpl<T>(this);
    }

    @Override
    public int getHash(int[] shape) {
        if (this.isDirty || this.hash == 0) {
            this.isDirty = true;
            this.refresh(true, new boolean[0]);
        }
        int rank = shape == null ? 0 : shape.length;
        int shash = this.hash;
        int i = 0;
        while (i < rank) {
            shash = shash * 17 + shape[i];
            ++i;
        }
        return shash;
    }

    @Override
    public void setHash(int hash) {
        this.hash = hash;
    }

    @Override
    public T getMaximum(boolean ... ignoreInvalids) {
        int idx = this.refresh(this.isize == 1, ignoreInvalids);
        return this.mms[idx].maximum;
    }

    @Override
    public void setMaximumMinimum(T maximum, T minimum, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        MaxMin<T> mm = this.mms[idx];
        mm.maximum = maximum;
        mm.minimum = minimum;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
    }

    @Override
    public void setMaximumPositions(List<int[]> maximumPositions, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        this.mms[idx].maximumPositions = maximumPositions;
    }

    @Override
    public List<int[]> getMaximumPositions(boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        return this.mms[idx].maximumPositions;
    }

    @Override
    public T getMinimum(boolean ... ignoreInvalids) {
        int idx = this.refresh(this.isize == 1, ignoreInvalids);
        return this.mms[idx].minimum;
    }

    @Override
    public List<int[]> getMinimumPositions(boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        return this.mms[idx].minimumPositions;
    }

    @Override
    public void setMinimumPositions(List<int[]> minimumPositions, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        this.mms[idx].minimumPositions = minimumPositions;
    }

    @Override
    public long getCount(boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        return this.summaries[idx][0].getN();
    }

    @Override
    public T getMean(boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        SummaryStatistics[] summary = this.summaries[idx];
        if (this.isize == 1) {
            return (T)Double.valueOf(summary[0].getMean());
        }
        double[] result = new double[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = summary[i].getMean();
            ++i;
        }
        return (T)result;
    }

    @Override
    public T getSum(boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        SummaryStatistics[] summary = this.summaries[idx];
        if (this.isize == 1) {
            return (T)Double.valueOf(summary[0].getSum());
        }
        double[] result = new double[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = summary[i].getSum();
            ++i;
        }
        return (T)result;
    }

    @Override
    public double getVariance(boolean isWholePopulation, boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        SummaryStatistics[] summary = this.summaries[idx];
        if (this.isize == 1) {
            return isWholePopulation ? summary[0].getPopulationVariance() : summary[0].getVariance();
        }
        double result = 0.0;
        int i = 0;
        while (i < this.isize) {
            result += isWholePopulation ? summary[i].getPopulationVariance() : summary[i].getVariance();
            ++i;
        }
        return result;
    }

    private int refresh(int axis, boolean ... ignoreInvalids) {
        int axisOffset;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (this.dataset.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if (this.isDirty) {
            this.clearAll();
        }
        if (this.axisStats[axisOffset = (ignoreNaNs ? 1 : 0) * 2 + (ignoreInfs ? 1 : 0) + 4 * axis] == null) {
            this.axisStats[axisOffset] = this.createAxisStats(axis, ignoreNaNs, ignoreInfs);
        }
        this.isDirty = false;
        return axisOffset;
    }

    private Dataset[] createAxisStats(int axis, boolean ignoreNaNs, boolean ignoreInfs) {
        AbstractDataset var;
        AbstractDataset mean;
        Dataset sum;
        IntegerDataset minIndex;
        IntegerDataset maxIndex;
        Dataset min;
        Dataset max;
        LongDataset count;
        block59: {
            int[] spos;
            int[] qpos;
            IndexIterator qiter;
            int alen;
            int rank;
            block52: {
                rank = this.dataset.getRank();
                int[] oshape = this.dataset.getShape();
                alen = oshape[axis];
                oshape[axis] = 1;
                int[] nshape = new int[rank - 1];
                int i = 0;
                while (i < axis) {
                    nshape[i] = oshape[i];
                    ++i;
                }
                i = axis + 1;
                while (i < rank) {
                    nshape[i - 1] = oshape[i];
                    ++i;
                }
                count = DatasetFactory.zeros(LongDataset.class, nshape);
                if (this.isize == 1) {
                    max = DatasetFactory.zeros(nshape, this.dtype);
                    min = DatasetFactory.zeros(nshape, this.dtype);
                    maxIndex = DatasetFactory.zeros(IntegerDataset.class, nshape);
                    minIndex = DatasetFactory.zeros(IntegerDataset.class, nshape);
                    sum = DatasetFactory.zeros(nshape, DTypeUtils.getLargestDType(this.dtype));
                    mean = DatasetFactory.zeros(DoubleDataset.class, nshape);
                    var = DatasetFactory.zeros(DoubleDataset.class, nshape);
                } else {
                    max = null;
                    min = null;
                    maxIndex = null;
                    minIndex = null;
                    sum = DatasetFactory.zeros(this.isize, nshape, DTypeUtils.getLargestDType(this.dtype));
                    mean = DatasetFactory.zeros(this.isize, CompoundDoubleDataset.class, nshape);
                    var = DatasetFactory.zeros(this.isize, CompoundDoubleDataset.class, nshape);
                }
                qiter = count.getIterator(true);
                qpos = qiter.getPos();
                spos = (int[])oshape.clone();
                if (this.isize != 1) break block52;
                DoubleDataset lmean = (DoubleDataset)mean;
                DoubleDataset lvar = (DoubleDataset)var;
                SummaryStatistics stats = new SummaryStatistics();
                while (qiter.hasNext()) {
                    double val;
                    int j;
                    boolean hasNaNs;
                    double amin;
                    double amax;
                    block54: {
                        int j2;
                        block53: {
                            int i2 = 0;
                            while (i2 < axis) {
                                spos[i2] = qpos[i2];
                                ++i2;
                            }
                            spos[i2++] = 0;
                            while (i2 < rank) {
                                spos[i2] = qpos[i2 - 1];
                                ++i2;
                            }
                            stats.clear();
                            stats.setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
                            amax = Double.NEGATIVE_INFINITY;
                            amin = Double.POSITIVE_INFINITY;
                            hasNaNs = false;
                            if (!ignoreNaNs) break block53;
                            j2 = 0;
                            while (j2 < alen) {
                                spos[axis] = j2;
                                double val2 = this.dataset.getDouble(spos);
                                if (Double.isNaN(val2)) {
                                    hasNaNs = true;
                                } else if (!ignoreInfs || !Double.isInfinite(val2)) {
                                    if (val2 > amax) {
                                        amax = val2;
                                    }
                                    if (val2 < amin) {
                                        amin = val2;
                                    }
                                    stats.addValue(val2);
                                }
                                ++j2;
                            }
                            break block54;
                        }
                        j2 = 0;
                        while (j2 < alen) {
                            block56: {
                                double val3;
                                block58: {
                                    block57: {
                                        block55: {
                                            spos[axis] = j2;
                                            val3 = this.dataset.getDouble(spos);
                                            if (!hasNaNs) break block55;
                                            if (!Double.isNaN(val3)) {
                                                stats.addValue(0.0);
                                            }
                                            break block56;
                                        }
                                        if (!Double.isNaN(val3)) break block57;
                                        amax = Double.NaN;
                                        amin = Double.NaN;
                                        hasNaNs = true;
                                        break block58;
                                    }
                                    if (ignoreInfs && Double.isInfinite(val3)) break block56;
                                    if (val3 > amax) {
                                        amax = val3;
                                    }
                                    if (val3 < amin) {
                                        amin = val3;
                                    }
                                }
                                stats.addValue(val3);
                            }
                            ++j2;
                        }
                    }
                    count.setAbs(qiter.index, stats.getN());
                    max.set((Object)amax, qpos);
                    min.set((Object)amin, qpos);
                    boolean fmax = false;
                    boolean fmin = false;
                    if (hasNaNs) {
                        if (ignoreNaNs) {
                            j = 0;
                            while (j < alen) {
                                spos[axis] = j;
                                val = this.dataset.getDouble(spos);
                                if (!Double.isNaN(val)) {
                                    if (!fmax && val == amax) {
                                        maxIndex.setAbs(qiter.index, j);
                                        fmax = true;
                                        if (fmin) break;
                                    }
                                    if (!fmin && val == amin) {
                                        minIndex.setAbs(qiter.index, j);
                                        fmin = true;
                                        if (fmax) break;
                                    }
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < alen) {
                                spos[axis] = j++;
                                val = this.dataset.getDouble(spos);
                                if (!Double.isNaN(val)) continue;
                                maxIndex.setAbs(qiter.index, j);
                                minIndex.setAbs(qiter.index, j);
                                break;
                            }
                        }
                    } else {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            val = this.dataset.getDouble(spos);
                            if (!fmax && val == amax) {
                                maxIndex.setAbs(qiter.index, j);
                                fmax = true;
                                if (fmin) break;
                            }
                            if (!fmin && val == amin) {
                                minIndex.setAbs(qiter.index, j);
                                fmin = true;
                                if (fmax) break;
                            }
                            ++j;
                        }
                    }
                    sum.setObjectAbs(qiter.index, stats.getSum());
                    lmean.setAbs(qiter.index, stats.getMean());
                    lvar.setAbs(qiter.index, stats.getVariance());
                }
                break block59;
            }
            CompoundDataset ldataset = (CompoundDataset)this.dataset;
            AbstractDataset lmean = mean;
            AbstractDataset lvar = var;
            double[] darray = new double[this.isize];
            while (qiter.hasNext()) {
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                SummaryStatistics[] stats = new SummaryStatistics[this.isize];
                int k = 0;
                while (k < this.isize) {
                    stats[k] = new SummaryStatistics();
                    ++k;
                }
                int j = 0;
                while (j < alen) {
                    spos[axis] = j;
                    ldataset.getDoubleArray(darray, spos);
                    boolean skip = false;
                    int k2 = 0;
                    while (k2 < this.isize) {
                        double v = darray[k2];
                        if (ignoreNaNs && Double.isNaN(v)) {
                            skip = true;
                            break;
                        }
                        if (ignoreInfs && Double.isInfinite(v)) {
                            skip = true;
                            break;
                        }
                        ++k2;
                    }
                    if (!skip) {
                        k2 = 0;
                        while (k2 < this.isize) {
                            stats[k2].addValue(darray[k2]);
                            ++k2;
                        }
                    }
                    ++j;
                }
                count.setAbs(qiter.index, (int)stats[0].getN());
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getSum();
                    ++k;
                }
                sum.set((Object)darray, qpos);
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getMean();
                    ++k;
                }
                ((CompoundDoubleDataset)lmean).setItem(darray, qpos);
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getVariance();
                    ++k;
                }
                ((CompoundDoubleDataset)lvar).setItem(darray, qpos);
            }
        }
        return new Dataset[]{max, min, maxIndex, minIndex, count, mean, sum, var};
    }

    @Override
    public Dataset getMaximum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][0];
    }

    @Override
    public Dataset getMinimum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][1];
    }

    @Override
    public Dataset getArgMaximum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][2];
    }

    @Override
    public Dataset getArgMinimum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][3];
    }

    @Override
    public Dataset getCount(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][4];
    }

    @Override
    public Dataset getMean(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][5];
    }

    @Override
    public Dataset getSum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.axisStats[axisOffset][6];
    }

    @Override
    public Dataset getVariance(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        Dataset v = this.axisStats[axisOffset][7];
        if (isWholePopulation) {
            Dataset c = this.axisStats[axisOffset][4];
            v = Maths.multiply(v, Maths.subtract(c, 1.0).idivide(c));
        }
        return v;
    }

    private static class MaxMin<T>
    implements Serializable {
        private static final long serialVersionUID = -8707875904521260325L;
        T maximum;
        T minimum;
        List<int[]> maximumPositions;
        List<int[]> minimumPositions;

        private MaxMin() {
        }
    }
}

