/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.notification.mail.smtp;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.kuksa.notification.mail.MailSender;
import org.eclipse.kuksa.notification.mail.entity.Mail;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.Mailer;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.ServerConfig;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmtpSender
implements MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpSender.class);
    private final Mailer mailer;
    private final String senderAddress;
    private final String senderName;

    public SmtpSender(String transport, String host, int port, String user, String password, String senderAddress, String senderName) throws IllegalArgumentException {
        Objects.requireNonNull(transport);
        Objects.requireNonNull(host);
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        Objects.requireNonNull(senderAddress);
        this.mailer = MailerBuilder.withTransportStrategy((TransportStrategy)SmtpSender.getTransportStrategy((String)transport)).withSMTPServerHost(host).withSMTPServerPort(Integer.valueOf(port)).withSMTPServerUsername(user).withSMTPServerPassword(password).buildMailer();
        this.senderAddress = senderAddress;
        this.senderName = senderName != null ? senderName : senderAddress;
    }

    public boolean testConnection() {
        ServerConfig config = this.mailer.getServerConfig();
        if (config == null) {
            LOGGER.error("The connection configuration is not set. Unable to test connection.");
            return false;
        }
        LOGGER.info("Testing to connect to {}:{}", (Object)config.getHost(), (Object)config.getPort());
        try {
            this.mailer.testConnection();
        }
        catch (Exception e) {
            LOGGER.error("Connection test failed.");
            e.printStackTrace();
            return false;
        }
        LOGGER.info("Connection test successful.");
        return true;
    }

    public void sendEmail(Mail mail) {
        Email email = EmailBuilder.startingBlank().from(this.senderName, this.senderAddress).toMultiple((Collection)mail.getTo()).withSubject(mail.getSubject()).withHTMLText(mail.getBody()).buildEmail();
        this.mailer.sendMail(email, false);
    }

    private static TransportStrategy getTransportStrategy(String s) throws IllegalArgumentException {
        switch (s.toUpperCase()) {
            case "SMTP": {
                return TransportStrategy.SMTP;
            }
            case "SMTPS": {
                return TransportStrategy.SMTPS;
            }
            case "SMTP_TLS": {
                return TransportStrategy.SMTP_TLS;
            }
        }
        LOGGER.error("'{}' is an unsupported transfer protocol.", (Object)s);
        throw new IllegalArgumentException("Unsupported transfer protocol set. 'SMTP', 'SMTPS' and 'SMTP_TLS' available.");
    }
}

