/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.honoConnector.influxdb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.eclipse.kuksa.honoConnector.message.MessageDTO;
import org.eclipse.kuksa.honoConnector.message.MessageHandler;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBException;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InfluxDBClient
implements MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDBClient.class);
    private final InfluxDB influxDB;
    private final String dbName;

    public InfluxDBClient(String influxURL, String dbName) throws MalformedURLException {
        this.dbName = dbName;
        URL url = new URL(influxURL);
        this.influxDB = InfluxDBFactory.connect((String)url.toString());
        LOGGER.info("Connected to InfluxDB at {} with database name {}", (Object)url.toString(), (Object)dbName);
        BiConsumer<Iterable, Throwable> consumer = (points, throwable) -> {
            if (throwable instanceof InfluxDBException.DatabaseNotFoundException) {
                if (!this.createDatabase()) {
                    LOGGER.error("Failed to create the database {}. Will drop pending points.", (Object)dbName);
                    return;
                }
                for (Point point : points) {
                    this.writePoint(point);
                }
            }
        };
        ThreadFactory factory = Executors.defaultThreadFactory();
        this.influxDB.enableBatch(10, 100, TimeUnit.MILLISECONDS, factory, consumer);
    }

    private boolean createDatabase() {
        String query = String.format("CREATE DATABASE \"%s\"", this.dbName);
        QueryResult result = this.influxDB.query(new Query(query, this.dbName, true));
        return result != null && !result.hasError();
    }

    public void process(MessageDTO msg) {
        if (msg == null) {
            return;
        }
        Map entries = msg.getEntries();
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Point point = InfluxDBClient.createPoint((long)System.currentTimeMillis(), (String)msg.getDeviceID(), (Map)entries);
        this.writePoint(point);
    }

    public static Point createPoint(long timestampMs, String deviceID, Map<String, Object> entries) {
        Point.Builder pointBuilder = Point.measurement((String)deviceID).time(timestampMs, TimeUnit.MILLISECONDS);
        entries.forEach(InfluxDBClient.addFields((Point.Builder)pointBuilder));
        return pointBuilder.build();
    }

    private static BiConsumer<String, Object> addFields(Point.Builder pointBuilder) {
        return (key, value) -> {
            if (value instanceof Boolean) {
                pointBuilder.addField(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Number) {
                pointBuilder.addField(key, ((Number)value).doubleValue());
            } else {
                pointBuilder.addField(key, value.toString());
            }
        };
    }

    private void writePoint(Point point) {
        this.influxDB.write(this.dbName, "autogen", point);
    }

    public void close() {
        this.influxDB.close();
    }
}

