/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.controller;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.ForbiddenException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"org.eclipse.kuksa.appstore.controller"})
public class ExceptionController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={AlreadyExistException.class})
    @ResponseStatus(code=HttpStatus.CONFLICT)
    @ResponseBody
    public ResponseEntity<?> handleAlreadyExistException(AlreadyExistException ex) {
        this.LOGGER.error("[AlreadyExistException] Exception: {}", (Object)ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(code=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ResponseEntity<?> handleNotFoundException(NotFoundException ex) {
        this.LOGGER.error("[NotFoundException] Exception: {}", (Object)ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ResponseEntity<?> handleForbiddenException(ForbiddenException ex) {
        this.LOGGER.error("[ForbiddenException] Exception: {}", (Object)ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<?> handleMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        this.LOGGER.error("[handleMethodArgumentNotValidException]: Method Argument Not Valid Exception  handler. Exception Message -> {}", (Object)ex.getBindingResult().getFieldError().getDefaultMessage());
        return new ResponseEntity((Object)ex.getBindingResult().getFieldError().getDefaultMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    @ResponseBody
    public ResponseEntity<?> handleInvalidFormatException(InvalidFormatException ex) {
        this.LOGGER.error("[handleInvalidFormatException] Exception: {}", (Object)ex.getMessage());
        String errorResponseText = null;
        errorResponseText = ex.getPath() != null && !ex.getPath().isEmpty() ? (ex.getTargetType().getEnumConstants() != null && ex.getTargetType().getEnumConstants().length > 0 ? "ADEM" : ex.getOriginalMessage()) : "Invalid JSON format!";
        return new ResponseEntity((Object)errorResponseText, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ResponseEntity<?> handleBadRequestException(BadRequestException ex) {
        this.LOGGER.error("[BadRequestException] Exception: {}", (Object)ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.BAD_REQUEST);
    }
}

