/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.service.OemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1.0"})
@Api(value="/api/1.0", description="OEM API", tags={"OEM"}, consumes="application/json")
public class OemController {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OemService oemService;

    @ApiOperation(notes="Returns the OEM specified by the oemId parameter.", value="Getting an OEM", nickname="getOEM", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/oem/{oemId}"})
    public ResponseEntity<?> getOembyId(@PathVariable Long oemId) throws NotFoundException {
        Oem oem = this.oemService.findById(oemId);
        if (oem != null) {
            this.LOG.debug("[getOembyId]: getOembyId request is processed successfully. Oem: {}", (Object)oemId);
            return new ResponseEntity((Object)oem, HttpStatus.OK);
        }
        this.LOG.debug("[getOembyId]: getOembyId request is received. Oem: {}", (Object)oemId);
        throw new NotFoundException("User not found!");
    }

    @ApiOperation(notes="Creates an OEM defined in the request JSON body. Id field should not implemented in post request JSON body because of that it is already given by server.", value="Create an Oem", nickname="createOem", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/oem"})
    public ResponseEntity<?> createOem(@Valid @RequestBody Oem oem) throws AlreadyExistException, BadRequestException {
        Result response = this.oemService.createOem(oem);
        if (response.isSuccess()) {
            this.LOG.debug("[createOem]: createOem request is processed successfully. oem: {}", (Object)oem);
            return new ResponseEntity(response.getPayload(), HttpStatus.CREATED);
        }
        this.LOG.debug("[createOem]: createOem request is received. oem: {}", (Object)oem);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Updates an OEM defined in the request JSON body.", value="Updating an OEM", nickname="updateOEM", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PutMapping(value={"/oem/{oemId}"})
    public ResponseEntity<?> updateOEM(@PathVariable Long oemId, @Valid @RequestBody Oem oem) throws AlreadyExistException, BadRequestException, NotFoundException {
        Result response = this.oemService.updateOem(oemId, oem);
        if (response.isSuccess()) {
            this.LOG.debug("[updateOEM]: updateOEM request is processed successfully. oem: {}", (Object)oem);
            return new ResponseEntity(response.getPayload(), HttpStatus.OK);
        }
        this.LOG.debug("[updateOEM]: updateOEM request is received. oem: {}", (Object)oem);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Deletes an OEM specified by oemId parameter.", value="Deleting an OEM", nickname="deleteOEM", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @DeleteMapping(value={"/oem/{oemId}"})
    public ResponseEntity<?> deleteOEM(@PathVariable Long oemId) throws NotFoundException, BadRequestException {
        this.LOG.debug("[deleteOEM]: Delete OEM request is received. oemId: {}", (Object)oemId);
        this.oemService.deleteOem(oemId);
        this.LOG.debug("[deleteOEM] Delete OEM is processed successfully. oemId: {}", (Object)oemId);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns all OEM.", value="Getting all OEM", nickname="getAllOEM", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/oem"})
    public ResponseEntity<?> getAllOEM(Pageable pageable) throws NotFoundException {
        Page oems = this.oemService.findAll(pageable);
        if (oems.getTotalElements() > 0L) {
            this.LOG.debug("[getAllOEM]: getAllOEM request is processed successfully.");
            return new ResponseEntity((Object)oems, HttpStatus.OK);
        }
        this.LOG.debug("[getAllOEM]: getAllOEM request is received.");
        throw new NotFoundException("OEMs not found!");
    }
}

