/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1.0"})
@Api(value="/api/1.0", description="User API", tags={"User"}, consumes="application/json")
public class UserController {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserService userService;
    @Autowired
    AppService appService;

    @ApiOperation(notes="Returns the User specified by the userId parameter. The response includes all details about the User.", value="Getting an User", nickname="getUserbyId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/user/{userId}"})
    public ResponseEntity<?> getUserbyId(@PathVariable String userId) throws NotFoundException {
        User user = this.userService.findById(userId);
        if (user != null) {
            this.LOG.debug("[getUserbyId]: getUserbyId request is processed successfully. Device: {}", (Object)userId);
            return new ResponseEntity((Object)user, HttpStatus.OK);
        }
        this.LOG.debug("[getUserbyId]: getUserbyId request is received. Device: {}", (Object)userId);
        throw new NotFoundException("User not found!");
    }

    @ApiOperation(notes="Creates an User defined in the request JSON body. Id field should not implemented in post request JSON body because of that it is already given by server.", value="Create an User", nickname="createUser", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/user"})
    public ResponseEntity<?> createUser(@Valid @RequestBody User user) throws AlreadyExistException, BadRequestException {
        Result response = this.userService.createUser(user.getUsername(), user.getPassword(), user.getUserType(), user.getOem(), user.getMembers());
        if (response.isSuccess()) {
            this.LOG.debug("[createUser]: createUser request is processed successfully. user: {}", (Object)user);
            return new ResponseEntity(response.getPayload(), HttpStatus.CREATED);
        }
        this.LOG.debug("[createUser]: createUser request is received. user: {}", (Object)user);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Updates the User identified by the appId parameter and the JSON body.", value="Updating an User", nickname="updateUser", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PutMapping(value={"/user/{userId}"})
    public ResponseEntity<?> updateUser(@PathVariable String userId, @Valid @RequestBody User user) throws AlreadyExistException, BadRequestException, NotFoundException {
        Result response = this.userService.updateUser(userId, user);
        if (response.isSuccess()) {
            this.LOG.debug("[updateUser]: updateUser request is processed successfully. user: {}", (Object)user);
            return new ResponseEntity(response.getPayload(), HttpStatus.OK);
        }
        this.LOG.debug("[updateUser]: updateUser request is received. user: {}", (Object)user);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Deletes the User specified by the userId path parameter.", value="Deleting an User", nickname="deleteUser", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @DeleteMapping(value={"/user/{userId}"})
    public ResponseEntity<?> deleteUser(@PathVariable String userId) throws NotFoundException {
        this.LOG.debug("[deleteUser]: Delete User request is received. userId: {}", (Object)userId);
        this.userService.deleteUser(userId);
        this.LOG.debug("[deleteUser] Delete User is processed successfully. userId: {}", (Object)userId);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns all Users.", value="Getting all User", nickname="getAllUser", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/user"})
    public ResponseEntity<?> getAllUser(Pageable pageable) throws NotFoundException {
        Page users = this.userService.findAll(pageable);
        this.LOG.debug("[getUserbyId]: getUserbyId request is processed successfully.");
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @ApiOperation(notes="This process is used to validate a given user.", value="Validating an User", nickname="validationUser", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/user/validation"})
    public ResponseEntity<?> validationUser(@RequestBody User user) throws NotFoundException, BadRequestException {
        User currentUser = this.userService.findByUserNameAndPassword(user.getUsername(), user.getPassword());
        if (currentUser != null) {
            this.LOG.debug("[validationUser]: validationUser request is processed successfully. user: {}", (Object)currentUser);
            return new ResponseEntity((Object)currentUser, HttpStatus.OK);
        }
        this.LOG.debug("[validationUser]: validationUser request is received. user: {}", (Object)currentUser);
        throw new NotFoundException("User not found!");
    }
}

