/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.UserType;

@Entity
@Table(name="user")
public class User
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="user_name")
    private String username;
    @NotNull
    @Column(name="password")
    private String password;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @Column(name="usertype")
    private UserType userType;
    @ManyToMany(mappedBy="installedusers", fetch=FetchType.EAGER)
    private List<App> installedapps;
    @ManyToMany(mappedBy="ownerusers", fetch=FetchType.EAGER)
    private List<App> userapps;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="oem_id", nullable=true)
    private Oem oem;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    @JoinTable(name="members", joinColumns={@JoinColumn(name="user", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="member", referencedColumnName="id")})
    private Set<User> members;

    public User(Long id, String username, String password, UserType userType, Oem oem, Set<User> members) {
        this.password = password;
        this.username = username;
        this.userType = userType;
        this.id = id;
        this.oem = oem;
        this.members = members;
    }

    public User() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    @JsonIgnore
    public List<App> getInstalledapps() {
        return this.installedapps;
    }

    public void setInstalledapps(List<App> installedapps) {
        this.installedapps = installedapps;
    }

    @JsonIgnore
    public List<App> getUserapps() {
        return this.userapps;
    }

    public void setUserapps(List<App> userapps) {
        this.userapps = userapps;
    }

    public Oem getOem() {
        return this.oem;
    }

    public void setOem(Oem oem) {
        this.oem = oem;
    }

    public Set<User> getMembers() {
        return this.members;
    }

    public void setMembers(Set<User> members) {
        this.members = members;
    }
}

