/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.model.hawkbit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.http.HttpStatus;

public class Result<T> {
    private final boolean success;
    private final T payload;
    private final HttpStatus statusCode;
    private final String errorMessage;

    @JsonCreator
    public Result(@JsonProperty(value="success") boolean success, @JsonProperty(value="payload") T payload, @JsonProperty(value="statusCode") HttpStatus statusCode, @JsonProperty(value="errorMessage") String errorMessage) {
        this.success = success;
        this.payload = payload;
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    public static final <T> Result<T> success(HttpStatus statusCode, T payload) {
        return new Result(true, payload, statusCode, null);
    }

    public static final <T> Result<T> success(HttpStatus statusCode) {
        return new Result(true, null, statusCode, null);
    }

    public static final <T> Result<T> fail(HttpStatus statusCode, String errorMessage) {
        return new Result(false, null, statusCode, errorMessage);
    }

    public static final <T> Result<T> fail(HttpStatus statusCode) {
        return new Result(false, null, statusCode, null);
    }

    public final boolean isSuccess() {
        return this.success;
    }

    public final T getPayload() {
        return (T)this.payload;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Result");
        sb.append("[");
        sb.append("success=");
        sb.append(this.success);
        sb.append(", ");
        sb.append("payload=");
        sb.append(this.payload);
        sb.append(", ");
        sb.append("statusCode=");
        sb.append(this.statusCode);
        sb.append(", ");
        sb.append("errorMessage=");
        sb.append(this.errorMessage);
        sb.append("]");
        return sb.toString();
    }
}

