/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.model.hawkbit.upload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class ArtifactFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    private final String contentType;
    private final byte[] content;

    public ArtifactFile(String name, byte[] content) {
        this(name, "", null, content);
    }

    public ArtifactFile(String name, String originalFilename, String contentType, byte[] content) {
        Assert.hasLength((String)name, (String)"Name must not be null");
        this.name = name;
        this.originalFilename = Optional.ofNullable(originalFilename).orElse("");
        this.contentType = contentType;
        this.content = Optional.ofNullable(content).orElse(new byte[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException {
        FileCopyUtils.copy((byte[])this.content, (File)dest);
    }
}

