/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.repo.OemRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class OemService {
    @Autowired
    OemRepository oemRepository;

    public Result<?> createOem(Oem oem) throws AlreadyExistException, BadRequestException {
        if (oem.getName() == null || oem.getName().equals("") || oem.getName().contains(" ")) {
            throw new BadRequestException("Name is mandatory field!");
        }
        if (this.oemRepository.findByNameIgnoreCase(oem.getName()) != null) {
            throw new AlreadyExistException("Oem name already exist. name: " + oem.getName());
        }
        this.oemRepository.save((Object)oem);
        return Result.success((HttpStatus)HttpStatus.CREATED, (Object)oem);
    }

    public Oem findById(Long id) {
        return this.oemRepository.findById(id);
    }

    public Oem findByName(String name) {
        return this.oemRepository.findByNameIgnoreCase(name);
    }

    public void updateOem(Oem oem) {
        this.oemRepository.save((Object)oem);
    }

    public Result<?> updateOem(Long oemId, Oem oem) throws NotFoundException, BadRequestException, AlreadyExistException {
        Oem currentOEM = this.oemRepository.findById(oemId);
        if (currentOEM == null) {
            throw new NotFoundException(" currentOEM not found. appId: " + oemId);
        }
        if (oem.getName() == null || oem.getName().equals("") || oem.getName().contains(" ")) {
            throw new BadRequestException("OEM name is mandatory field!");
        }
        if (!currentOEM.getName().equals(oem.getName()) && this.oemRepository.findByName(oem.getName()) != null) {
            throw new AlreadyExistException("New Oem name already exist. New oem name: " + oem.getName());
        }
        oem.setId(currentOEM.getId());
        this.oemRepository.save((Object)oem);
        return Result.success((HttpStatus)HttpStatus.OK, (Object)oem);
    }

    public void deleteOem(Oem oem) {
        this.oemRepository.delete((Object)oem);
    }

    public void deleteOem(Long oemId) throws NotFoundException, BadRequestException {
        Oem currentOem = this.oemRepository.findById(oemId);
        if (currentOem == null) {
            throw new NotFoundException("Oem not found. userId: " + oemId);
        }
        try {
            this.oemRepository.delete((Object)currentOem);
        }
        catch (Exception e) {
            throw new BadRequestException("This OEM is being used by users. Please update the users's OEM before deleting.");
        }
    }

    public List<Oem> findAll() {
        return this.oemRepository.findAll();
    }

    public Page<Oem> findAll(Pageable pageable) {
        return this.oemRepository.findAll(pageable);
    }

    public List<String> getAllId() {
        ArrayList<String> list = new ArrayList<String>();
        for (Long component : this.oemRepository.getAllId()) {
            list.add(component.toString());
        }
        return list;
    }
}

