/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.service;

import java.util.List;
import java.util.Set;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.repo.UserRepository;
import org.eclipse.kuksa.appstore.service.AppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    UserRepository userRepository;
    @Autowired
    AppService appService;

    public Result<?> createUser(String username, String password, UserType usertype, Oem oem, Set<User> members) throws AlreadyExistException, BadRequestException {
        User newUser = new User(null, username, password, usertype, oem, members);
        if (username == null || password == null || username.equals("") || password.equals("") || username.contains(" ") || password.contains(" ")) {
            throw new BadRequestException("Username and password are mandatory field!");
        }
        if (this.userRepository.findByUsername(username) != null) {
            throw new AlreadyExistException("User name already exist. username: " + username);
        }
        this.userRepository.save((Object)newUser);
        return Result.success((HttpStatus)HttpStatus.CREATED, (Object)this.userRepository.findByUsername(username));
    }

    public void updateUser(User userObject) {
        this.userRepository.save((Object)userObject);
    }

    public Result<?> updateUser(String userId, User userObject) throws NotFoundException, BadRequestException, AlreadyExistException {
        User currentUser = this.userRepository.findById(Long.valueOf(Long.parseLong(userId)));
        if (currentUser == null) {
            throw new NotFoundException("User not found. userId: " + userId);
        }
        if (userObject.getId() != null && !userObject.getId().toString().equals(userId)) {
            throw new BadRequestException("The userId parameter and id of userObject should be same!");
        }
        if (userObject.getUsername() == null || userObject.getUsername().equals("")) {
            throw new BadRequestException("Username is mandatory field!");
        }
        if (userObject.getPassword() == null || userObject.getPassword().equals("")) {
            throw new BadRequestException("Password is mandatory field!");
        }
        if (userObject.getUsername().contains(" ") || userObject.getPassword().contains(" ")) {
            throw new BadRequestException("Username or password should not contains space character!");
        }
        if (!currentUser.getUsername().equals(userObject.getUsername()) && this.userRepository.findByUsername(userObject.getUsername()) != null) {
            throw new AlreadyExistException("New User name already exist. New username: " + userObject.getUsername());
        }
        userObject.setId(currentUser.getId());
        this.userRepository.save((Object)userObject);
        return Result.success((HttpStatus)HttpStatus.OK, (Object)userObject);
    }

    public void deleteAllMembers(String userId) {
        this.userRepository.deleteAllMembers(userId);
    }

    public void deleteUser(User userObject) {
        this.userRepository.delete((Object)userObject);
    }

    public void deleteUser(String userId) throws NotFoundException {
        User currentUser = this.userRepository.findById(Long.valueOf(Long.parseLong(userId)));
        if (currentUser == null) {
            throw new NotFoundException("User not found. userId: " + userId);
        }
        this.userRepository.delete((Object)currentUser);
    }

    public User findByUserNameAndPassword(String username, String password) {
        return this.userRepository.findByUsernameAndPassword(username, password);
    }

    public User findById(String id) {
        return this.userRepository.findById(Long.valueOf(Long.parseLong(id)));
    }

    public User findByUserName(String userName) {
        return this.userRepository.findByUsername(userName);
    }

    public List<User> findAll() {
        return this.userRepository.findAll();
    }

    public Page<User> findAll(Pageable pageable) {
        return this.userRepository.findAll(pageable);
    }

    public List<User> findByUserNameStartsWithIgnoreCase(String username) {
        return this.userRepository.findByUsernameStartsWithIgnoreCase(username);
    }

    public List<User> findByIdNotIn(List<Long> notInList) {
        return this.userRepository.findByIdNotIn(notInList);
    }

    public boolean isUsersAppOwner(String userId, Long appId, List<String> oemList) {
        return this.appService.createUsersAppList(userId, oemList).contains(appId);
    }
}

