/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Setter;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eclipse.kuksa.appstore.client.HawkbitFeignClient;
import org.eclipse.kuksa.appstore.client.HawkbitMultiPartFileFeignClient;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModuleResult;
import org.eclipse.kuksa.appstore.service.AppCategoryService;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.ui.AppEditor;
import org.eclipse.kuksa.appstore.ui.ArtifactFileEditor;
import org.eclipse.kuksa.appstore.ui.VaadinUI;
import org.eclipse.kuksa.appstore.utils.Utils;

@SpringComponent
@UIScope
public class AppEditor
extends VerticalLayout
implements View {
    AppService appService;
    AppCategoryService appCategoryService;
    public App app;
    public TextField name = new TextField("App Name");
    public TextArea description = new TextArea("Description");
    public TextField version = new TextField("Version");
    public TextField owner = new TextField("Owner");
    public Button save = new Button("Save", (Resource)FontAwesome.SAVE);
    public Button delete = new Button("Delete", (Resource)FontAwesome.TRASH_O);
    public Button artifactDetailsBtn = new Button("Artifacts Details", (Resource)FontAwesome.FILE);
    public ComboBox<String> categoryComboBox = new ComboBox("Select A Category");
    public Upload upload;
    public Embedded appimage;
    HorizontalLayout subHlayout = new HorizontalLayout();
    VerticalLayout mainVLayout = new VerticalLayout();
    Binder<App> binder = new Binder(App.class);
    HawkbitFeignClient hawkbitFeignClient;
    HawkbitMultiPartFileFeignClient hawkbitMultiPartFileFeignClient;
    final Window artifactFileEditorWindow = new Window("Artifact File");
    final ArtifactFileEditor artifactFileEditor = new ArtifactFileEditor();
    SoftwareModuleResult softwareModuleResult;

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public void setAppCategoryService(AppCategoryService appCategoryService) {
        this.appCategoryService = appCategoryService;
    }

    public void setMessageFeignClient(HawkbitFeignClient hawkbitFeignClient) {
        this.hawkbitFeignClient = hawkbitFeignClient;
    }

    public void setHawkbitFeignClient(HawkbitMultiPartFileFeignClient hawkbitMultiPartFileFeignClient) {
        this.hawkbitMultiPartFileFeignClient = hawkbitMultiPartFileFeignClient;
    }

    public AppEditor() {
        this.name.setWidth("220px");
        this.name.setPlaceholder("App Name");
        this.description.setWidth("450px");
        this.description.setHeight("180px");
        this.description.setPlaceholder("Description");
        this.version.setWidth("220px");
        this.version.setPlaceholder("Version");
        this.owner.setWidth("220px");
        this.owner.setPlaceholder("Owner");
        this.categoryComboBox.setWidth("220px");
        this.categoryComboBox.setEmptySelectionAllowed(false);
        this.appimage = new Embedded("App Image");
        this.appimage.setVisible(false);
        this.appimage.setWidth("75");
        this.appimage.setHeight("50");
        VerticalLayout popupContent = new VerticalLayout();
        popupContent.addComponent((Component)this.artifactFileEditor);
        this.artifactFileEditorWindow.setContent((Component)popupContent);
        this.artifactFileEditorWindow.center();
        this.artifactFileEditorWindow.setModal(true);
        this.artifactFileEditorWindow.setResizable(false);
        ImageUploader receiver = new ImageUploader(this);
        this.upload = new Upload(null, (Upload.Receiver)receiver);
        this.upload.setButtonCaption("Add or Change Image");
        this.upload.addSucceededListener((Upload.SucceededListener)receiver);
        1 icg = new /* Unavailable Anonymous Inner Class!! */;
        this.categoryComboBox.setPlaceholder("No category selected");
        this.categoryComboBox.setEmptySelectionAllowed(false);
        this.categoryComboBox.setItemCaptionGenerator((ItemCaptionGenerator)icg);
        this.subHlayout.addComponents(new Component[]{this.name, this.version});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.subHlayout = new HorizontalLayout();
        this.subHlayout.addComponents(new Component[]{this.owner, this.categoryComboBox});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.subHlayout = new HorizontalLayout();
        this.subHlayout.addComponents(new Component[]{this.description});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.subHlayout = new HorizontalLayout();
        this.subHlayout.addComponents(new Component[]{this.artifactDetailsBtn, this.upload});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.subHlayout = new HorizontalLayout();
        this.subHlayout.addComponents(new Component[]{this.appimage});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.subHlayout = new HorizontalLayout();
        this.subHlayout.addComponents(new Component[]{this.save, this.delete});
        this.mainVLayout.addComponent((Component)this.subHlayout);
        this.addComponents(new Component[]{this.mainVLayout});
        this.binder.forField((HasValue)this.categoryComboBox).bind((ValueProvider & Serializable)App2 -> {
            if (App2.getAppcategory() != null) {
                return App2.getAppcategory().getId().toString();
            }
            return null;
        }, (Setter & Serializable)(App2, categoryId) -> {
            Long id = Long.parseLong(categoryId);
            App2.setAppcategory(this.appCategoryService.findById(id));
        });
        this.binder.bindInstanceFields((Object)this);
        this.setSpacing(true);
        this.save.setStyleName("primary");
        this.save.setClickShortcut(13, new int[0]);
        this.delete.setStyleName("danger");
        this.artifactDetailsBtn.setStyleName("icon-align-right");
        this.artifactDetailsBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            this.artifactFileEditorWindow.center();
            VaadinUI.getCurrent().addWindow(this.artifactFileEditorWindow);
            this.artifactFileEditor.setmessageFeignClient(this.hawkbitFeignClient);
            this.artifactFileEditor.setHawkbitFeignClient(this.hawkbitMultiPartFileFeignClient);
            this.artifactFileEditor.editArtifactFile(Utils.getExistsSoftwareModule((List)this.softwareModuleResult.getContent()).toString());
        });
        this.setVisible(false);
    }

    public final void editApp(App s) {
        if (s == null) {
            this.setVisible(false);
            return;
        }
        boolean persisted = s.getId() != null;
        this.app = persisted ? this.appService.findById(s.getId()) : s;
        this.delete.setVisible(persisted);
        this.upload.setVisible(persisted);
        this.appimage.setVisible(persisted);
        this.artifactDetailsBtn.setVisible(persisted);
        this.binder.setBean((Object)this.app);
        this.setVisible(true);
        this.save.focus();
        this.name.selectAll();
        List list = this.appCategoryService.getAllId();
        if (list.size() > 0) {
            this.categoryComboBox.setItems((Collection)list);
        } else {
            new Notification("Not Found Any App Category!", "Please add an App Category before you want to add an app!", Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
        }
        if (this.app.getName() != null && !this.app.getName().equals("")) {
            try {
                this.softwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)this.app.getName()) + ";" + Utils.createFIQLEqual((String)"version", (String)this.app.getVersion()));
            }
            catch (Exception e) {
                new Notification("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        }
    }

    public void setChangeHandler(ChangeHandler h) {
        this.save.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
        this.delete.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }
}

