/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamVariable;
import com.vaadin.server.ThemeResource;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.dnd.FileDropHandler;
import com.vaadin.ui.dnd.FileDropTarget;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.ClickableRenderer;
import com.vaadin.ui.renderers.ImageRenderer;
import feign.Response;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eclipse.kuksa.appstore.client.HawkbitFeignClient;
import org.eclipse.kuksa.appstore.client.HawkbitMultiPartFileFeignClient;
import org.eclipse.kuksa.appstore.model.hawkbit.Artifact;
import org.eclipse.kuksa.appstore.model.hawkbit.upload.ArtifactFile;
import org.eclipse.kuksa.appstore.ui.ArtifactFileEditor;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

@SpringComponent
@UIScope
public class ArtifactFileEditor
extends VerticalLayout
implements View {
    VerticalLayout mainLayout = new VerticalLayout();
    HorizontalLayout vlayout = new HorizontalLayout();
    Grid<Artifact> artifactGrid = new Grid(Artifact.class);
    public Upload upload;
    HawkbitFeignClient hawkbitFeignClient;
    HawkbitMultiPartFileFeignClient hawkbitMultiPartFileFeignClient;
    String softwareModuleId;

    public ArtifactFileEditor() {
        ImageUploader receiver = new ImageUploader(this);
        this.upload = new Upload(null, (Upload.Receiver)receiver);
        this.upload.setButtonCaption("Click to Upload Artifact File");
        this.upload.addSucceededListener((Upload.SucceededListener)receiver);
        this.vlayout = new HorizontalLayout();
        this.vlayout.addComponents(new Component[]{this.artifactGrid});
        this.mainLayout.addComponent((Component)this.vlayout);
        this.vlayout = new HorizontalLayout();
        this.vlayout.addComponents(new Component[]{this.createDropPane()});
        this.mainLayout.addComponent((Component)this.vlayout);
        this.artifactGrid.setSelectionMode(Grid.SelectionMode.NONE);
        this.artifactGrid.setColumns(new String[]{"id", "providedFilename", "size"});
        this.artifactGrid.setCaption("Artifact Files");
        this.artifactGrid.getColumn("size").setCaption("Size (B)");
        this.artifactGrid.getColumn("providedFilename").setCaption("Filename");
        this.artifactGrid.setWidth(500.0f, Sizeable.Unit.PIXELS);
        this.artifactGrid.setHeight(300.0f, Sizeable.Unit.PIXELS);
        this.addDeleteColumn("Delete");
        this.addComponents(new Component[]{this.mainLayout});
        this.setSpacing(true);
    }

    public void setmessageFeignClient(HawkbitFeignClient hawkbitFeignClient) {
        this.hawkbitFeignClient = hawkbitFeignClient;
    }

    public void setHawkbitFeignClient(HawkbitMultiPartFileFeignClient hawkbitMultiPartFileFeignClient) {
        this.hawkbitMultiPartFileFeignClient = hawkbitMultiPartFileFeignClient;
    }

    public final void editArtifactFile(String softwareModuleIdArgument) {
        if (softwareModuleIdArgument == null) {
            this.setVisible(false);
            return;
        }
        this.fillGrids(softwareModuleIdArgument);
        this.softwareModuleId = softwareModuleIdArgument;
    }

    public void fillGrids(String softwareModuleId) {
        try {
            List artifactResultList = this.hawkbitFeignClient.getArtifactsBysoftwareModuleId(softwareModuleId);
            this.artifactGrid.setItems((Collection)artifactResultList);
        }
        catch (Exception e) {
            new Notification("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
        }
    }

    private void addDeleteColumn(String caption) {
        ImageRenderer renderer = new ImageRenderer();
        renderer.addClickListener((ClickableRenderer.RendererClickListener & Serializable)e -> this.deleteArtifact((Artifact)e.getItem()));
        Grid.Column iconColumn = this.artifactGrid.addColumn((ValueProvider & Serializable)i -> new ThemeResource("img/delete.png"), (AbstractRenderer)renderer);
        iconColumn.setCaption(caption);
        iconColumn.setMaximumWidth(100.0);
        this.artifactGrid.addItemClickListener((ItemClickListener & Serializable)e -> {
            if (e.getColumn().equals((Object)iconColumn)) {
                this.deleteArtifact((Artifact)e.getItem());
            }
        });
    }

    private void deleteArtifact(Artifact artifact) {
        try {
            Response response = this.hawkbitFeignClient.deleteArtifactsBysoftwareModuleId(this.softwareModuleId, artifact.getId());
            if (response.status() == HttpStatus.OK.value()) {
                new Notification("The artifact is successfully deleted.", Notification.Type.HUMANIZED_MESSAGE).show(Page.getCurrent());
                this.fillGrids(this.softwareModuleId);
            } else {
                new Notification("The deleting process is failed.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        }
        catch (Exception e) {
            new Notification("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
        }
    }

    private void uploadArtifactFile(String name, byte[] b) {
        ArtifactFile appArtifactFile = new ArtifactFile(name, name, "multipart/form-data", b);
        try {
            Response response = this.hawkbitMultiPartFileFeignClient.uploadFile(this.softwareModuleId, (MultipartFile)appArtifactFile);
            if (response.status() == HttpStatus.CREATED.value()) {
                new Notification("The artifact is successfully uploaded!", Notification.Type.HUMANIZED_MESSAGE).show(Page.getCurrent());
                this.fillGrids(this.softwareModuleId);
            } else {
                new Notification("The uploading process is failed!", response.reason(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        }
        catch (Exception e) {
            new Notification("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
        }
    }

    private VerticalLayout createDropPane() {
        Image imageDragAndDrop = new Image();
        imageDragAndDrop.setWidth("40");
        imageDragAndDrop.setHeight("40");
        imageDragAndDrop.setSource((Resource)new ThemeResource("img/dragandrop.png"));
        VerticalLayout dropPane = new VerticalLayout(new Component[]{imageDragAndDrop, new Label("Drop Artifact File to upload"), new Label("or"), this.upload});
        dropPane.addStyleName("drop-area");
        dropPane.setWidth(500.0f, Sizeable.Unit.PIXELS);
        ProgressBar progress = new ProgressBar();
        progress.setIndeterminate(true);
        progress.setVisible(false);
        dropPane.addComponent((Component)progress);
        new FileDropTarget((AbstractComponent)dropPane, (FileDropHandler & Serializable)fileDropEvent -> {
            int fileSizeLimit = 0xC800000;
            fileDropEvent.getFiles().forEach(html5File -> {
                String fileName = html5File.getFileName();
                if (html5File.getFileSize() > 0xC800000L) {
                    Notification.show((String)"File rejected. Max 200MB files are accepted by Sampler", (Notification.Type)Notification.Type.WARNING_MESSAGE);
                } else {
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    1 streamVariable = new /* Unavailable Anonymous Inner Class!! */;
                    html5File.setStreamVariable((StreamVariable)streamVariable);
                    progress.setVisible(true);
                }
            });
        });
        return dropPane;
    }

    static /* synthetic */ void access$000(ArtifactFileEditor x0, String x1, byte[] x2) {
        x0.uploadArtifactFile(x1, x2);
    }
}

