/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.addon.pagination.Pagination;
import com.vaadin.data.HasValue;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.hawkbit.Distribution;
import org.eclipse.kuksa.appstore.model.hawkbit.DistributionResult;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModule;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.springframework.beans.factory.annotation.Autowired;

@SpringView(name="installedapps")
public class InstalledAppsListView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "installedapps";
    public static final String TITLE_NAME = "Installed Apps";
    private final Button uninstallAppBtn = new Button("Uninstall", (Resource)FontAwesome.TRASH_O);
    private final Button selectAllAppBtn = new Button("Select All", (Resource)FontAwesome.CHECK_SQUARE_O);
    private final Button deselectAllAppBtn = new Button("Deselect All", (Resource)FontAwesome.SQUARE_O);
    ListSelect<String> sample;
    VerticalLayout mainlayout;
    VerticalLayout appslayout;
    HorizontalLayout navHeaderLayout;
    HorizontalLayout actions;
    @Autowired
    AppService appService;
    @Autowired
    UserService userService;
    List<String> data;
    ComboBox<String> comboBoxDevice;
    HorizontalLayout actionList;

    @Autowired
    public InstalledAppsListView() {
        Page.getCurrent().setTitle(TITLE_NAME);
        this.appslayout = new VerticalLayout();
        this.mainlayout = new VerticalLayout();
        this.uninstallAppBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            Set selectedApps = this.sample.getSelectedItems();
            ArrayList<Long> appIds = new ArrayList<Long>();
            for (String appName : selectedApps) {
                appIds.add(this.appService.findByName(appName).getId());
            }
            if (appIds.size() != 0) {
                try {
                    this.appService.UninstallMultiApp(((String)this.comboBoxDevice.getSelectedItem().get()).toString(), this.userService.findByUserName(VaadinSession.getCurrent().getAttribute("user").toString()).getId(), appIds);
                    this.listInstalledApps(((String)this.comboBoxDevice.getSelectedItem().get()).toString());
                    new Notification("Succes Unistalling", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                }
                catch (NotFoundException e1) {
                    new Notification("Failed Unistalling", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
                catch (BadRequestException e1) {
                    new Notification("Failed Unistalling", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
                catch (AlreadyExistException e1) {
                    new Notification("Failed Unistalling", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
            } else {
                new Notification("Select at least one application to uninstall", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        this.selectAllAppBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            for (String app : this.data) {
                this.sample.select((Object[])new String[]{app});
            }
        });
        this.deselectAllAppBtn.addClickListener((Button.ClickListener & Serializable)e -> this.sample.deselectAll());
    }

    @PostConstruct
    public void init() {
        this.navHeaderLayout = new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString());
        this.mainlayout.addComponent((Component)this.navHeaderLayout);
        this.comboBoxDevice = new ComboBox();
        try {
            this.comboBoxDevice.setItems((Collection)this.appService.getListOfTargets(this.userService.findByUserName(VaadinSession.getCurrent().getAttribute("user").toString()).getId()));
        }
        catch (BadRequestException e) {
            e.printStackTrace();
        }
        this.comboBoxDevice.setPlaceholder("No device selected");
        this.comboBoxDevice.setEmptySelectionAllowed(false);
        this.comboBoxDevice.setWidth("300");
        HorizontalLayout actionBar = new HorizontalLayout();
        actionBar.addComponent((Component)this.selectAllAppBtn);
        actionBar.addComponent((Component)this.deselectAllAppBtn);
        actionBar.addComponent((Component)this.uninstallAppBtn);
        this.appslayout.addComponent((Component)actionBar);
        this.actionList = new HorizontalLayout();
        this.actionList.setWidth(50.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)this.actionList);
        this.listInstalledApps(null);
        this.comboBoxDevice.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.listInstalledApps(((String)this.comboBoxDevice.getSelectedItem().get()).toString()));
        Label selectDeviceLabel = new Label("Select a device");
        this.actions = new HorizontalLayout(new Component[]{selectDeviceLabel, this.comboBoxDevice});
        this.actions.setStyleName("v-actions");
        this.mainlayout.addComponent((Component)this.actions);
        this.mainlayout.addComponent((Component)this.appslayout);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    private VerticalLayout createContent(Pagination pagination) {
        VerticalLayout layout = new VerticalLayout();
        layout.setSizeFull();
        layout.setSpacing(true);
        layout.addComponents(new Component[]{pagination});
        return layout;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    public void listInstalledApps(String targetDeviceName) {
        this.data = new ArrayList();
        try {
            DistributionResult distributionResult;
            if (targetDeviceName != null && (distributionResult = this.appService.getDistributionOfTarget(targetDeviceName)).getSize() > 0) {
                List softwareModules = ((Distribution)distributionResult.getContent().get(0)).getModules();
                for (SoftwareModule softwareModule : softwareModules) {
                    if (softwareModule.getName().equals("UNINSTALLED_ALL")) continue;
                    this.data.add(softwareModule.getName());
                }
                if (this.data.size() == 0) {
                    new Notification("There is no installed application for this device.", Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
                }
            }
            this.sample = new ListSelect("You can use Ctrl|Shift keys to select multi rows.", (Collection)this.data);
            this.sample.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
            this.actionList.removeAllComponents();
            this.actionList.addComponent((Component)this.sample);
        }
        catch (BadRequestException e) {
            e.printStackTrace();
        }
    }
}

