/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.Binder;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.service.OemService;
import org.eclipse.kuksa.appstore.ui.OemEditor;
import org.springframework.beans.factory.annotation.Autowired;

@SpringComponent
@UIScope
public class OemEditor
extends VerticalLayout
implements View {
    @Autowired
    OemService oemService;
    public Oem oem;
    public TextField name = new TextField("Oem Name");
    public Button save = new Button("Save", (Resource)FontAwesome.SAVE);
    public Button cancel = new Button("Cancel", (Resource)FontAwesome.CLOSE);
    public Button delete = new Button("Delete", (Resource)FontAwesome.TRASH_O);
    HorizontalLayout hlayout = new HorizontalLayout();
    VerticalLayout vlayout = new VerticalLayout();
    Binder<Oem> binder = new Binder(Oem.class);

    @Autowired
    public OemEditor() {
        this.name.setWidth("200px");
        this.vlayout.addComponents(new Component[]{this.name});
        this.hlayout.addComponent((Component)this.vlayout);
        this.vlayout = new VerticalLayout();
        this.hlayout.addComponent((Component)this.vlayout);
        this.vlayout = new VerticalLayout();
        this.vlayout.addComponents(new Component[]{this.save, this.delete, this.cancel});
        this.hlayout.addComponent((Component)this.vlayout);
        this.vlayout = new VerticalLayout();
        this.hlayout.addComponent((Component)this.vlayout);
        this.addComponents(new Component[]{this.hlayout});
        this.binder.bindInstanceFields((Object)this);
        this.setSpacing(true);
        this.save.setStyleName("primary");
        this.save.setClickShortcut(13, new int[0]);
        this.setVisible(false);
    }

    public final void editOem(Oem s) {
        if (s == null) {
            this.setVisible(false);
            return;
        }
        boolean persisted = s.getId() != null;
        this.oem = persisted ? this.oemService.findById(s.getId()) : s;
        this.delete.setVisible(persisted);
        this.cancel.setVisible(true);
        this.binder.setBean((Object)this.oem);
        this.setVisible(true);
        this.save.focus();
        this.name.selectAll();
    }

    public void setChangeHandler(ChangeHandler h) {
        this.save.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
        this.delete.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }
}

