/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.HasValue;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.PopupView;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.EditorSaveEvent;
import com.vaadin.ui.components.grid.EditorSaveListener;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.AppCategory;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.service.AppCategoryService;
import org.eclipse.kuksa.appstore.service.OemService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.AppCategoryEditor;
import org.eclipse.kuksa.appstore.ui.OemEditor;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.springframework.beans.factory.annotation.Autowired;

@SpringView(name="profile")
public class ProfileEditView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "profile";
    public static final String TITLE_NAME = "My Profile";
    final Grid<AppCategory> gridAppCategory = new Grid();
    final Grid<Oem> gridOem = new Grid();
    private PasswordField currentPassword = new PasswordField("Current Password");
    private PasswordField newPassword = new PasswordField("New Password");
    private PasswordField repeatNewPassword = new PasswordField("Repeat New Password");
    private Button save = new Button("Save");
    @Autowired
    UserService userService;
    @Autowired
    AppCategoryService appCategoryService;
    @Autowired
    OemService oemService;
    private final AppCategoryEditor appCategoryEditor;
    private final PopupView popupCategory;
    private final Button addNewCategoryBtn = new Button("", (Resource)FontAwesome.PLUS);
    private final Button deleteCategoryBtn = new Button("", (Resource)FontAwesome.TRASH_O);
    private final OemEditor oemEditor;
    private final PopupView popupOem;
    private final Button addNewOemBtn = new Button("", (Resource)FontAwesome.PLUS);
    private final Button deleteOemBtn = new Button("", (Resource)FontAwesome.TRASH_O);

    @Autowired
    public ProfileEditView(AppCategoryEditor appCategoryEditor, OemEditor oemEditor) {
        this.appCategoryEditor = appCategoryEditor;
        this.oemEditor = oemEditor;
        Page.getCurrent().setTitle(TITLE_NAME);
        VerticalLayout popupCategoryContent = new VerticalLayout();
        popupCategoryContent.addComponent((Component)appCategoryEditor);
        this.popupCategory = new PopupView(null, (Component)popupCategoryContent);
        VerticalLayout popupOemContent = new VerticalLayout();
        popupOemContent.addComponent((Component)oemEditor);
        this.popupOem = new PopupView(null, (Component)popupOemContent);
        this.addNewCategoryBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            this.popupCategory.setPopupVisible(true);
            appCategoryEditor.editAppCategory(new AppCategory());
        });
        this.deleteCategoryBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            try {
                if (this.gridAppCategory.asSingleSelect().getValue() != null) {
                    this.appCategoryService.deleteAppCategory(((AppCategory)this.gridAppCategory.asSingleSelect().getValue()).getId().toString());
                    this.listAppCategories();
                    new Notification("Succes Deleting", "The App Category has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                } else {
                    new Notification("No selected row", "Make sure that You selected any row to delete", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
            }
            catch (BadRequestException | NotFoundException e1) {
                new Notification("Error", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        appCategoryEditor.save.addClickListener((Button.ClickListener & Serializable)e -> {
            if (appCategoryEditor.appCategory.getName() != null && !appCategoryEditor.appCategory.getName().isEmpty()) {
                if (appCategoryEditor.appCategory.getId() != null) {
                    this.appCategoryService.updateAppCategory(appCategoryEditor.appCategory);
                    this.listAppCategories();
                    appCategoryEditor.setVisible(false);
                    this.popupCategory.setPopupVisible(false);
                    new Notification("Succes Updating", "The App Category has been updated.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                } else {
                    try {
                        this.appCategoryService.createAppCategory(appCategoryEditor.appCategory);
                        this.listAppCategories();
                        appCategoryEditor.setVisible(false);
                        this.popupCategory.setPopupVisible(false);
                        new Notification("Succes Creating", "The App Category has been created.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                    }
                    catch (AlreadyExistException e1) {
                        new Notification("Already Exist Exception", "App Category Name already exists.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                    catch (BadRequestException e1) {
                        new Notification("Bad Request Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                }
            } else {
                new Notification("Fill the mandatory fields", "App Category Name is mandatory fields.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        appCategoryEditor.delete.addClickListener((Button.ClickListener & Serializable)e -> {
            this.appCategoryService.deleteAppCategory(appCategoryEditor.appCategory);
            this.listAppCategories();
            appCategoryEditor.setVisible(false);
            this.popupCategory.setPopupVisible(false);
            new Notification("Succes Deleting", "The App Category has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
        });
        appCategoryEditor.cancel.addClickListener((Button.ClickListener & Serializable)e -> {
            this.listAppCategories();
            appCategoryEditor.setVisible(false);
            this.popupCategory.setPopupVisible(false);
        });
        this.addNewOemBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            this.popupOem.setPopupVisible(true);
            oemEditor.editOem(new Oem());
        });
        this.deleteOemBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            try {
                if (this.gridOem.asSingleSelect().getValue() != null) {
                    this.oemService.deleteOem(((Oem)this.gridOem.asSingleSelect().getValue()).getId());
                    this.listOems();
                    new Notification("Succes Deleting", "The Oem has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                } else {
                    new Notification("No selected row", "Make sure that You selected any row to delete", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
            }
            catch (BadRequestException | NotFoundException e1) {
                new Notification("Error", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        oemEditor.save.addClickListener((Button.ClickListener & Serializable)e -> {
            if (oemEditor.oem.getName() != null && !oemEditor.oem.getName().isEmpty()) {
                if (oemEditor.oem.getId() != null) {
                    this.oemService.updateOem(oemEditor.oem);
                    this.listOems();
                    oemEditor.setVisible(false);
                    this.popupOem.setPopupVisible(false);
                    new Notification("Succes Updating", "The Oem has been updated.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                } else {
                    try {
                        this.oemService.createOem(oemEditor.oem);
                        this.listOems();
                        oemEditor.setVisible(false);
                        this.popupOem.setPopupVisible(false);
                        new Notification("Succes Creating", "The Oem has been created.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                    }
                    catch (AlreadyExistException e1) {
                        new Notification("Already Exist Exception", "Oem Name already exists.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                    catch (BadRequestException e1) {
                        new Notification("Bad Request Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                }
            } else {
                new Notification("Fill the mandatory fields", "Oem Name is mandatory fields.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        oemEditor.delete.addClickListener((Button.ClickListener & Serializable)e -> {
            this.oemService.deleteOem(oemEditor.oem);
            this.listOems();
            oemEditor.setVisible(false);
            this.popupOem.setPopupVisible(false);
            new Notification("Succes Deleting", "The Oem has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
        });
        oemEditor.cancel.addClickListener((Button.ClickListener & Serializable)e -> {
            this.listOems();
            oemEditor.setVisible(false);
            this.popupOem.setPopupVisible(false);
        });
    }

    @PostConstruct
    public void init() {
        this.popupCategory.setHideOnMouseOut(false);
        this.popupOem.setHideOnMouseOut(false);
        VerticalLayout mainLayout = new VerticalLayout(new Component[]{new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString())});
        HorizontalLayout subHorizontalLayout = new HorizontalLayout();
        mainLayout.addComponent((Component)subHorizontalLayout);
        this.setCompositionRoot((Component)mainLayout);
        this.currentPassword.setPlaceholder("Current Password");
        this.newPassword.setPlaceholder("New Password");
        this.repeatNewPassword.setPlaceholder("Repeat New Password");
        Panel panelPassword = new Panel("Change Password");
        panelPassword.setSizeUndefined();
        FormLayout content = new FormLayout();
        content.addComponent((Component)this.currentPassword);
        content.addComponent((Component)this.newPassword);
        content.addComponent((Component)this.repeatNewPassword);
        content.addComponent((Component)this.save);
        content.setSizeUndefined();
        content.setMargin(true);
        panelPassword.setContent((Component)content);
        mainLayout.addComponent((Component)panelPassword);
        this.save.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Panel categoryPanel = new Panel("Application Category");
        categoryPanel.setSizeUndefined();
        VerticalLayout categoryLayout = new VerticalLayout();
        HorizontalLayout categoryActionsLayout = new HorizontalLayout();
        this.gridAppCategory.setSizeFull();
        this.gridAppCategory.setSelectionMode(Grid.SelectionMode.SINGLE);
        TextField categoryNameEditor = new TextField();
        this.gridAppCategory.addColumn(AppCategory::getId, (AbstractRenderer)new TextRenderer()).setCaption("Id").setExpandRatio(1);
        this.gridAppCategory.addColumn(AppCategory::getName).setEditorComponent((HasValue)categoryNameEditor, AppCategory::setName).setCaption("App Category Name").setEditable(true).setExpandRatio(3);
        this.gridAppCategory.getEditor().setEnabled(true);
        this.gridAppCategory.getEditor().addSaveListener((EditorSaveListener & Serializable)e -> this.modifyAppCategory(e));
        this.listAppCategories();
        categoryActionsLayout.addComponents(new Component[]{this.addNewCategoryBtn, this.deleteCategoryBtn});
        categoryLayout.addComponent((Component)categoryActionsLayout);
        categoryLayout.addComponent((Component)this.gridAppCategory);
        categoryPanel.setContent((Component)categoryLayout);
        categoryActionsLayout.addComponent((Component)this.popupCategory);
        if (VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString().equals(UserType.SystemAdmin.toString())) {
            subHorizontalLayout.addComponent((Component)categoryPanel);
        }
        Panel oemPanel = new Panel("Oem");
        oemPanel.setSizeUndefined();
        VerticalLayout oemLayout = new VerticalLayout();
        HorizontalLayout oemActionsLayout = new HorizontalLayout();
        this.gridOem.setSizeFull();
        this.gridOem.setSelectionMode(Grid.SelectionMode.SINGLE);
        TextField oemNameEditor = new TextField();
        this.gridOem.addColumn(Oem::getId, (AbstractRenderer)new TextRenderer()).setCaption("Id").setExpandRatio(1);
        this.gridOem.addColumn(Oem::getName).setEditorComponent((HasValue)oemNameEditor, Oem::setName).setCaption("Oem Name").setEditable(true).setExpandRatio(3);
        this.gridOem.getEditor().setEnabled(true);
        this.gridOem.getEditor().addSaveListener((EditorSaveListener & Serializable)e -> this.modifyOem(e));
        this.listOems();
        oemActionsLayout.addComponents(new Component[]{this.addNewOemBtn, this.deleteOemBtn});
        oemLayout.addComponent((Component)oemActionsLayout);
        oemLayout.addComponent((Component)this.gridOem);
        oemPanel.setContent((Component)oemLayout);
        oemActionsLayout.addComponent((Component)this.popupOem);
        if (VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString().equals(UserType.SystemAdmin.toString())) {
            subHorizontalLayout.addComponent((Component)oemPanel);
        }
    }

    private void modifyAppCategory(EditorSaveEvent<AppCategory> e) {
        if (this.appCategoryService.findByName(((AppCategory)e.getBean()).getName()) != null && !this.appCategoryService.findByName(((AppCategory)e.getBean()).getName()).getId().equals(((AppCategory)e.getBean()).getId())) {
            Notification.show((String)"AppCategory name already exists.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
            this.listAppCategories();
        } else {
            this.appCategoryService.updateAppCategory((AppCategory)e.getBean());
            Notification.show((String)"Selected row modified successfully...", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
            this.listAppCategories();
        }
    }

    private void modifyOem(EditorSaveEvent<Oem> e) {
        if (this.oemService.findByName(((Oem)e.getBean()).getName()) != null && !this.oemService.findByName(((Oem)e.getBean()).getName()).getId().equals(((Oem)e.getBean()).getId())) {
            Notification.show((String)"Oem name already exists.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
            this.listOems();
        } else {
            this.oemService.updateOem((Oem)e.getBean());
            Notification.show((String)"Selected row modified successfully...", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
            this.listOems();
        }
    }

    void listAppCategories() {
        this.gridAppCategory.setItems((Collection)this.appCategoryService.findAll());
    }

    void listOems() {
        this.gridOem.setItems((Collection)this.oemService.findAll());
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    static /* synthetic */ PasswordField access$000(ProfileEditView x0) {
        return x0.currentPassword;
    }

    static /* synthetic */ PasswordField access$100(ProfileEditView x0) {
        return x0.repeatNewPassword;
    }

    static /* synthetic */ PasswordField access$200(ProfileEditView x0) {
        return x0.newPassword;
    }
}

