/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.annotation.SpringViewDisplay;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.repo.UserRepository;
import org.eclipse.kuksa.appstore.ui.AppEditView;
import org.eclipse.kuksa.appstore.ui.AppView;
import org.eclipse.kuksa.appstore.ui.AppsListView;
import org.eclipse.kuksa.appstore.ui.InstalledAppsListView;
import org.eclipse.kuksa.appstore.ui.LoginView;
import org.eclipse.kuksa.appstore.ui.ProfileEditView;
import org.eclipse.kuksa.appstore.ui.PurchasedAppsListView;
import org.eclipse.kuksa.appstore.ui.SignUpView;
import org.eclipse.kuksa.appstore.ui.UserEditView;
import org.springframework.beans.factory.annotation.Autowired;

@SpringUI
@SpringViewDisplay
@Theme(value="mytheme")
public class VaadinUI
extends UI {
    @Autowired
    private final UserRepository userRepository;

    @Autowired
    public VaadinUI(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    protected void init(VaadinRequest request) {
        VerticalLayout mainLayout = new VerticalLayout();
        LoginView loginView = new LoginView();
        mainLayout.addComponent((Component)loginView);
        mainLayout.setComponentAlignment((Component)loginView, Alignment.MIDDLE_CENTER);
        mainLayout.setSizeFull();
        this.setContent((Component)mainLayout);
        Page.getCurrent().addUriFragmentChangedListener((Page.UriFragmentChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.router("");
    }

    private void router(String route) {
        if (this.getSession().getAttribute("user") != null) {
            User loggedUser = this.userRepository.findByUsername(this.getSession().getAttribute("user").toString());
            this.getNavigator().addView("appedit", AppEditView.class);
            this.getNavigator().addView("applist", AppsListView.class);
            this.getNavigator().addView("app", AppView.class);
            this.getNavigator().addView("installedapps", InstalledAppsListView.class);
            this.getNavigator().addView("userlist", UserEditView.class);
            this.getNavigator().addView("signup", SignUpView.class);
            this.getNavigator().addView("profile", ProfileEditView.class);
            this.getNavigator().addView("purchasedapps", PurchasedAppsListView.class);
            if (route.equals("!appedit")) {
                if (loggedUser.getUserType() == UserType.SystemAdmin) {
                    Page.getCurrent().setUriFragment("!appedit");
                } else {
                    Page.getCurrent().setUriFragment("!applist");
                }
            } else if (route.equals("!applist")) {
                Page.getCurrent().setUriFragment("!applist");
            } else if (route.equals("!app")) {
                Page.getCurrent().setUriFragment("!app");
            } else if (route.equals("!installedapps")) {
                Page.getCurrent().setUriFragment("!installedapps");
            } else if (route.equals("!purchasedapps")) {
                Page.getCurrent().setUriFragment("!purchasedapps");
            } else if (route.equals("!profile")) {
                Page.getCurrent().setUriFragment("!profile");
            } else if (route.equals("!useredit")) {
                if (loggedUser.getUserType() == UserType.SystemAdmin) {
                    Page.getCurrent().setUriFragment("!userlist");
                } else {
                    Page.getCurrent().setUriFragment("!applist");
                }
            } else {
                String gotopage = Page.getCurrent().getUriFragment();
                if (gotopage == null) {
                    gotopage = "!applist";
                }
                Page.getCurrent().setUriFragment(gotopage);
            }
        } else if (route.equals("!signup")) {
            Page.getCurrent().setUriFragment("!signup");
        } else {
            Page.getCurrent().setUriFragment("!login");
        }
    }

    static /* synthetic */ void access$000(VaadinUI x0, String x1) {
        x0.router(x1);
    }
}

