/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(XmlUtil.class);
    private static Map<Class, JAXBContext> s_contexts = new HashMap<Class, JAXBContext>();

    public static String marshal(Object object) throws JAXBException {
        StringWriter sw = new StringWriter();
        XmlUtil.marshal(object, sw);
        return sw.toString();
    }

    public static void marshal(Object object, Writer w) throws JAXBException {
        Class<?> clazz = object.getClass();
        JAXBContext context = s_contexts.get(clazz);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            s_contexts.put(clazz, context);
        }
        ValidationEventCollector valEventHndlr = new ValidationEventCollector();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setSchema(null);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setEventHandler((ValidationEventHandler)valEventHndlr);
        try {
            marshaller.marshal(object, w);
        }
        catch (Exception e) {
            if (e instanceof JAXBException) {
                throw (JAXBException)e;
            }
            throw new MarshalException(e.getMessage(), (Throwable)e);
        }
        if (valEventHndlr.hasEvents()) {
            ValidationEvent[] validationEventArray = valEventHndlr.getEvents();
            int n = validationEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidationEvent valEvent = validationEventArray[n2];
                if (valEvent.getSeverity() != 0) {
                    throw new MarshalException(valEvent.getMessage(), valEvent.getLinkedException());
                }
                ++n2;
            }
        }
    }

    public static <T> T unmarshal(String s, Class<T> clazz) throws JAXBException, XMLStreamException, FactoryConfigurationError {
        StringReader sr = new StringReader(s);
        return XmlUtil.unmarshal(sr, clazz);
    }

    public static <T> T unmarshal(Reader r, Class<T> clazz) throws JAXBException, XMLStreamException, FactoryConfigurationError {
        JAXBContext context = s_contexts.get(clazz);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            s_contexts.put(clazz, context);
        }
        ValidationEventCollector valEventHndlr = new ValidationEventCollector();
        XMLStreamReader xmlsr = XMLInputFactory.newFactory().createXMLStreamReader(r);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(null);
        unmarshaller.setEventHandler((ValidationEventHandler)valEventHndlr);
        JAXBElement elem = null;
        try {
            elem = unmarshaller.unmarshal(xmlsr, clazz);
        }
        catch (Exception e) {
            if (e instanceof JAXBException) {
                throw (JAXBException)e;
            }
            throw new UnmarshalException(e.getMessage(), (Throwable)e);
        }
        if (valEventHndlr.hasEvents()) {
            ValidationEvent[] validationEventArray = valEventHndlr.getEvents();
            int n = validationEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidationEvent valEvent = validationEventArray[n2];
                if (valEvent.getSeverity() != 0) {
                    String msg = MessageFormat.format("Line {0}, Col: {1}: {2}", valEvent.getLocator().getLineNumber(), valEvent.getLocator().getColumnNumber(), valEvent.getLinkedException().getMessage());
                    throw new UnmarshalException(msg, valEvent.getLinkedException());
                }
                ++n2;
            }
        }
        return (T)elem.getValue();
    }
}

