/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.List;
import org.eclipse.kura.core.net.WifiInterfaceAddressImpl;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.wifi.WifiInterfaceAddress;
import org.eclipse.kura.net.wifi.WifiInterfaceAddressConfig;

public class WifiInterfaceAddressConfigImpl
extends WifiInterfaceAddressImpl
implements WifiInterfaceAddressConfig {
    private List<NetConfig> m_configs;

    public WifiInterfaceAddressConfigImpl() {
    }

    public WifiInterfaceAddressConfigImpl(WifiInterfaceAddress other) {
        super(other);
    }

    public List<NetConfig> getConfigs() {
        return this.m_configs;
    }

    public void setNetConfigs(List<NetConfig> configs) {
        this.m_configs = configs;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof WifiInterfaceAddressConfig)) {
            return false;
        }
        WifiInterfaceAddressConfig other = (WifiInterfaceAddressConfig)obj;
        if (!this.compare(this.getMode(), other.getMode())) {
            return false;
        }
        if (this.getBitrate() != other.getBitrate()) {
            return false;
        }
        if (!this.compare(this.getWifiAccessPoint(), other.getWifiAccessPoint())) {
            return false;
        }
        List<NetConfig> thisNetConfigs = this.getConfigs();
        List otherNetConfigs = other.getConfigs();
        if (thisNetConfigs.size() != otherNetConfigs.size()) {
            return false;
        }
        if (!thisNetConfigs.containsAll(otherNetConfigs)) {
            return false;
        }
        return otherNetConfigs.containsAll(thisNetConfigs);
    }

    public String toString() {
        if (this.m_configs != null) {
            StringBuffer sb = new StringBuffer();
            for (NetConfig netConfig : this.m_configs) {
                sb.append("NetConfig: ");
                if (netConfig != null) {
                    sb.append(netConfig.toString());
                } else {
                    sb.append("null");
                }
                sb.append(" - ");
            }
            return sb.toString();
        }
        return "NetConfig: no configurations";
    }
}

