/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.GraphChecks;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.SEPM;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.ValueIterationInt;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy.RatioGameEnergy;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.energy.EGIntImplJGraphT;

public class RatioGameValueIterationStrategyInt {
    private RatioGameValueIterationStrategyInt() {
    }

    public static <V, E> Tuple<Map<V, Fraction>, StrategyVector<V, E>> solve(RatioGameEnergy<V, E, Integer> game) {
        HashMap vertexMap = new HashMap();
        Fraction w = new Fraction(((Integer)game.getMaxAbsValue()).intValue());
        Fraction minusW = new Fraction(0);
        StrategyVector strategy = new StrategyVector();
        if (GraphChecks.checkEachNodeHasSuccessor(game)) {
            RatioGameValueIterationStrategyInt.solve(game, minusW, w, vertexMap, strategy);
            return Tuple.of(vertexMap, strategy);
        }
        System.out.println("Input game graph is not valid. Not every vertex has a successor.");
        return null;
    }

    private static <V, E> void solve(RatioGameEnergy<V, E, Integer> game, Fraction lowerBound, Fraction upperBound, Map<V, Fraction> valueMap, StrategyVector<V, E> strategy) {
        if (!game.getVertices().isEmpty()) {
            Fraction middle = lowerBound.add(upperBound).multiply(Fraction.ONE_HALF);
            Integer vSize = game.getVertices().size();
            Integer w = (Integer)game.getMaxAbsValue();
            Fraction a1 = RatioGameValueIterationStrategyInt.findMaxInRange(vSize, w, lowerBound, middle);
            Fraction a2 = RatioGameValueIterationStrategyInt.findMinInRange(vSize, w, middle, upperBound);
            Integer q1 = a1.getNumerator();
            Integer l1 = a1.getDenominator();
            Integer q2 = a2.getNumerator();
            Integer l2 = a2.getDenominator();
            RatioGameEnergy<V, E, Integer> gameSwapped = game.getSwappedSubGraph(game.getVertices());
            SingleWeightFunctionInt<E> wf1 = RatioGameValueIterationStrategyInt.convertToSingleWeightFunction(game, l1, -q1.intValue());
            EGIntImplJGraphT game1 = new EGIntImplJGraphT(game, wf1);
            SEPM f1 = ValueIterationInt.getProgressMeasure(game1);
            SingleWeightFunctionInt<E> wf2 = RatioGameValueIterationStrategyInt.convertToSingleWeightFunction(game, -l1.intValue(), q1);
            EGIntImplJGraphT game2 = new EGIntImplJGraphT(gameSwapped, wf2);
            SEPM f2 = ValueIterationInt.getProgressMeasure(game2);
            SingleWeightFunctionInt<E> wf3 = RatioGameValueIterationStrategyInt.convertToSingleWeightFunction(game, l2, -q2.intValue());
            EGIntImplJGraphT game3 = new EGIntImplJGraphT(game, wf3);
            SEPM f3 = ValueIterationInt.getProgressMeasure(game3);
            SingleWeightFunctionInt<E> wf4 = RatioGameValueIterationStrategyInt.convertToSingleWeightFunction(game, -l2.intValue(), q2);
            EGIntImplJGraphT game4 = new EGIntImplJGraphT(gameSwapped, wf4);
            SEPM f4 = ValueIterationInt.getProgressMeasure(game4);
            for (Object v2 : game.getVertices()) {
                Optional outgoing;
                if (!f1.getValue(v2).equals(ValueIterationInt.TOP) && !f2.getValue(v2).equals(ValueIterationInt.TOP)) {
                    valueMap.put((Fraction)v2, a1);
                    outgoing = game.getV0().contains(v2) ? ValueIterationInt.getSmallestConsistentSuccessor(game1, f1, v2) : ValueIterationInt.getLargestConsistentSuccessor(game1, f1, v2);
                    if (outgoing.isPresent()) {
                        strategy.setSuccessor(v2, game1.getEdgeTarget(outgoing.get()));
                    } else {
                        System.out.println("Cannot set successor 1");
                    }
                }
                if (f3.getValue(v2).equals(ValueIterationInt.TOP) || f4.getValue(v2).equals(ValueIterationInt.TOP)) continue;
                valueMap.put((Fraction)v2, a2);
                outgoing = game.getV0().contains(v2) ? ValueIterationInt.getSmallestConsistentSuccessor(game3, f3, v2) : ValueIterationInt.getLargestConsistentSuccessor(game3, f3, v2);
                if (outgoing.isPresent()) {
                    strategy.setSuccessor(v2, game3.getEdgeTarget(outgoing.get()));
                    continue;
                }
                System.out.println("Cannot set successor 2");
            }
            HashSet vSmallera1 = new HashSet();
            game.getVertices().stream().filter(v -> ((Integer)f1.getValue(v)).equals(ValueIterationInt.TOP)).forEach(vSmallera1::add);
            HashSet vLargera2 = new HashSet();
            game.getVertices().stream().filter(v -> ((Integer)f4.getValue(v)).equals(ValueIterationInt.TOP)).forEach(vLargera2::add);
            RatioGameEnergy<V, E, Integer> subGameSmallerVertices = game.getSubGraph(vSmallera1);
            RatioGameEnergy<V, E, Integer> subGameLargerVertices = game.getSubGraph(vLargera2);
            RatioGameValueIterationStrategyInt.solve(subGameSmallerVertices, lowerBound, a1, valueMap, strategy);
            RatioGameValueIterationStrategyInt.solve(subGameLargerVertices, a2, upperBound, valueMap, strategy);
        }
    }

    private static Fraction findMaxInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction min;
        Fraction max = min = lowerBound;
        int a = 0;
        while (a <= vertexSize * maxWeight) {
            int b = 1;
            while (b <= vertexSize * maxWeight) {
                Fraction pm = new Fraction(a, b);
                if (pm.compareTo(lowerBound) != -1 && pm.compareTo(upperBound) != 1 && pm.compareTo(max) > 0) {
                    max = pm;
                }
                ++b;
            }
            ++a;
        }
        return max;
    }

    private static Fraction findMinInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction max;
        Fraction min = max = upperBound;
        int a = 0;
        while (a <= vertexSize * maxWeight) {
            int b = 1;
            while (b <= vertexSize * maxWeight) {
                Fraction pm = new Fraction(a, b);
                if (pm.compareTo(lowerBound) != -1 && pm.compareTo(upperBound) != 1 && pm.compareTo(min) < 0) {
                    min = pm;
                }
                ++b;
            }
            ++a;
        }
        return min;
    }

    private static <V, E> SingleWeightFunctionInt<E> convertToSingleWeightFunction(RatioGameEnergy<V, E, Integer> game, Integer constant_a, Integer constant_b) {
        SingleWeightFunctionInt newFunction = new SingleWeightFunctionInt();
        for (Object edge : game.getEdges()) {
            Integer weight = constant_a * (Integer)game.getWeight1(edge) + constant_b * (Integer)game.getWeight2(edge);
            newFunction.addWeight(edge, weight);
        }
        return newFunction;
    }
}

