/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.lang.reflect.Field;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;
import org.eclipse.xtend.typesystem.emf.Mapping;

public class Setup {
    public Setup() {
        this.addEPackageClass(EcorePackage.eINSTANCE.getClass().getName());
    }

    public void addEPackageDescriptor(String descr) {
        EcoreUtil2.getEPackageByDescriptorClassName(descr);
    }

    public void addEPackageFile(String descr) {
        EcoreUtil2.getEPackage(descr);
    }

    public void addEPackageClass(String clazz) {
        EcoreUtil2.getEPackageByClassName(clazz);
    }

    public void addUriMap(Mapping uriMap) {
        URI baseUri = URI.createURI((String)uriMap.getFrom());
        URI mappedUri = EcoreUtil2.getURI(uriMap.getTo());
        if (mappedUri == null) {
            throw new ConfigurationException("cannot make URI out of " + uriMap.getTo());
        }
        URIConverter.URI_MAP.put(baseUri, mappedUri);
    }

    public void addExtensionMap(Mapping m) throws ConfigurationException {
        try {
            Class<?> factoryClass = ResourceLoaderFactory.createResourceLoader().loadClass(m.getTo());
            if (factoryClass == null) {
                throw new ConfigurationException("cannot find class " + m.getTo() + " for extension " + m.getFrom());
            }
            Object factoryInstance = null;
            if (factoryClass.isInterface()) {
                Class<?>[] innerClasses = factoryClass.getDeclaredClasses();
                factoryClass = null;
                int j = 0;
                while (j < innerClasses.length) {
                    if (Resource.Factory.class.isAssignableFrom(innerClasses[j])) {
                        factoryClass = innerClasses[j];
                    }
                    ++j;
                }
                if (factoryClass == null) {
                    throw new ConfigurationException("cannot find inner factory class " + m.getTo() + " for extension " + m.getFrom());
                }
                Field instanceField = factoryClass.getField("INSTANCE");
                factoryInstance = instanceField.get(null);
            } else {
                factoryInstance = factoryClass.newInstance();
            }
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(m.getFrom(), factoryInstance);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }
}

