/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.setext.texteditorbase.GenericTextEditor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class GenericTextEditorFolding {
    private static final String PACKAGE_NAME = GenericTextEditorFolding.class.getPackage().getName();
    private static final QualifiedName PERSIST_NAME = new QualifiedName(PACKAGE_NAME, "collapsedFoldRanges");
    private final GenericTextEditor<?, ?> textEditor;
    private ProjectionAnnotationModel projAnnoModel;
    private List<ProjectionAnnotation> curProjAnnos = new LinkedList<ProjectionAnnotation>();
    private Map<Annotation, Position> loadedAnnos = null;

    public GenericTextEditorFolding(GenericTextEditor<?, ?> textEditor) {
        this.textEditor = textEditor;
    }

    public void createPartControl(ISourceViewer sourceViewer, IAnnotationAccess annotationAccess, ISharedTextColors sharedColors) {
        ProjectionViewer viewer = (ProjectionViewer)sourceViewer;
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, annotationAccess, sharedColors);
        String errAnnoType = "org.eclipse.ui.workbench.texteditor.error";
        String warnAnnoType = "org.eclipse.ui.workbench.texteditor.warning";
        projectionSupport.addSummarizableAnnotationType(errAnnoType);
        projectionSupport.addSummarizableAnnotationType(warnAnnoType);
        projectionSupport.install();
        viewer.doOperation(19);
        this.projAnnoModel = viewer.getProjectionAnnotationModel();
        if (this.loadedAnnos != null) {
            this.projAnnoModel.replaceAnnotations(new Annotation[0], this.loadedAnnos);
            for (ProjectionAnnotation anno : this.curProjAnnos) {
                this.projAnnoModel.collapse((Annotation)anno);
            }
            this.loadedAnnos = null;
        }
    }

    public void updateFolds(List<Position> newRanges, String text) {
        LinkedList<ProjectionAnnotation> newProjAnnos = new LinkedList<ProjectionAnnotation>();
        Map annosAdded = Maps.map();
        block0: for (Position newRange : newRanges) {
            Iterator<ProjectionAnnotation> annoIter = this.curProjAnnos.iterator();
            while (annoIter.hasNext()) {
                ProjectionAnnotation oldAnno = annoIter.next();
                Position annoRange = this.projAnnoModel.getPosition((Annotation)oldAnno);
                if (annoRange == null || annoRange.offset != newRange.offset || annoRange.length != newRange.length) continue;
                newProjAnnos.add(oldAnno);
                annoIter.remove();
                continue block0;
            }
            ProjectionAnnotation newAnno = new ProjectionAnnotation();
            annosAdded.put(newAnno, newRange);
            newProjAnnos.add(newAnno);
        }
        boolean DEBUG = false;
        if (!this.curProjAnnos.isEmpty() || !annosAdded.isEmpty()) {
            Annotation[] annosDeleted = new Annotation[this.curProjAnnos.size()];
            annosDeleted = this.curProjAnnos.toArray(annosDeleted);
            this.projAnnoModel.replaceAnnotations(annosDeleted, annosAdded);
        }
        this.curProjAnnos = newProjAnnos;
    }

    public void fixFolds(List<Position> foldRanges, String text) {
        Iterator<Position> iter = foldRanges.iterator();
        while (iter.hasNext()) {
            Position foldRange = iter.next();
            while (foldRange.offset > 0 && text.charAt(foldRange.offset - 1) != '\n') {
                --foldRange.offset;
                ++foldRange.length;
            }
            int startOffset = foldRange.offset;
            int endOffset = startOffset + foldRange.length;
            while (endOffset < text.length() && text.charAt(endOffset - 1) != '\n') {
                ++endOffset;
            }
            foldRange.length = endOffset - startOffset;
            int cnt = 0;
            int i = startOffset;
            while (i < endOffset) {
                if (text.charAt(i) == '\n' && ++cnt > 1) break;
                ++i;
            }
            if (cnt >= 2) continue;
            iter.remove();
        }
    }

    public void save(IFileEditorInput input) {
        if (input == null) {
            return;
        }
        IFile file = input.getFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        List collapsedRanges = Lists.list();
        for (ProjectionAnnotation anno : this.curProjAnnos) {
            Position range;
            if (anno.isMarkedDeleted() || !anno.isCollapsed() || (range = this.projAnnoModel.getPosition((Annotation)anno)) == null) continue;
            collapsedRanges.add(range);
        }
        String data = this.serialize(collapsedRanges);
        try {
            file.setPersistentProperty(PERSIST_NAME, data);
        }
        catch (CoreException ex) {
            return;
        }
    }

    public void load() {
        FileEditorInput input = (FileEditorInput)this.textEditor.getEditorInput();
        if (input == null) {
            return;
        }
        IFile file = input.getFile();
        if (file == null) {
            return;
        }
        String data = null;
        try {
            data = file.getPersistentProperty(PERSIST_NAME);
        }
        catch (CoreException ex) {
            return;
        }
        if (data == null) {
            return;
        }
        List<Position> collapsedRanges = this.deserialize(data);
        if (collapsedRanges == null) {
            return;
        }
        if (collapsedRanges.isEmpty()) {
            return;
        }
        this.curProjAnnos = new LinkedList<ProjectionAnnotation>();
        this.loadedAnnos = Maps.mapc((int)collapsedRanges.size());
        for (Position range : collapsedRanges) {
            ProjectionAnnotation anno = new ProjectionAnnotation();
            this.loadedAnnos.put((Annotation)anno, range);
            this.curProjAnnos.add(anno);
        }
    }

    private String serialize(List<Position> foldRanges) {
        if (foldRanges.isEmpty()) {
            return null;
        }
        if (foldRanges.size() > 512) {
            foldRanges = foldRanges.subList(0, 512);
        }
        ByteBuffer bb = ByteBuffer.allocate(foldRanges.size() * 8);
        for (Position range : foldRanges) {
            bb.putInt(range.offset);
            bb.putInt(range.length);
        }
        Assert.check((!bb.hasRemaining() ? 1 : 0) != 0);
        bb.rewind();
        CharBuffer cb = bb.asCharBuffer();
        String rslt = cb.toString();
        Assert.check((rslt.length() <= 2048 ? 1 : 0) != 0);
        rslt.length();
        return rslt;
    }

    private List<Position> deserialize(String data) {
        if (data.length() % 4 != 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(data.length() * 2);
        CharBuffer cb = bb.asCharBuffer();
        cb.append(data);
        int count = data.length() / 4;
        List rslt = Lists.listc((int)count);
        int i = 0;
        while (i < count) {
            int offset = bb.getInt();
            int length = bb.getInt();
            if (offset < 0) {
                return null;
            }
            if (length < 0) {
                return null;
            }
            rslt.add(new Position(offset, length));
            ++i;
        }
        Assert.check((rslt.size() == count ? 1 : 0) != 0);
        return rslt;
    }
}

