/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.pdf.PDFGState;

public class PDFState {
    private Data data = new Data();
    private List stateStack = new ArrayList();

    public void push() {
        Data copy;
        try {
            copy = (Data)this.getData().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.stateStack.add(copy);
        this.data.resetConcatenations();
    }

    public Data getData() {
        return this.data;
    }

    public Data pop() {
        if (this.getStackLevel() > 0) {
            Data popped;
            this.data = popped = (Data)this.stateStack.remove(this.stateStack.size() - 1);
            return popped;
        }
        return null;
    }

    public int getStackLevel() {
        return this.stateStack.size();
    }

    public boolean setLineWidth(float width) {
        if (this.getData().lineWidth != width) {
            this.getData().lineWidth = width;
            return true;
        }
        return false;
    }

    public boolean setColor(Color col) {
        if (!col.equals(this.getData().color)) {
            this.getData().color = col;
            return true;
        }
        return false;
    }

    public boolean setBackColor(Color col) {
        if (!col.equals(this.getData().backcolor)) {
            this.getData().backcolor = col;
            return true;
        }
        return false;
    }

    public boolean setPaint(Paint p) {
        if (this.getData().paint == null) {
            if (p != null) {
                this.getData().paint = p;
                return true;
            }
        } else if (!this.data.paint.equals(p)) {
            this.getData().paint = p;
            return true;
        }
        return false;
    }

    public boolean checkClip(Shape cl) {
        return this.getData().clip == null ? cl != null : !new Area(this.getData().clip).equals(new Area(cl));
    }

    public void setClip(Shape cl) {
        if (this.getData().clip != null) {
            Area newClip = new Area(this.getData().clip);
            newClip.intersect(new Area(cl));
            this.getData().clip = new GeneralPath(newClip);
        } else {
            this.getData().clip = cl;
        }
    }

    public boolean checkTransform(AffineTransform tf) {
        return !tf.equals(this.getData().transform);
    }

    public void setTransform(AffineTransform tf) {
        this.getData().concatenate(tf);
    }

    public AffineTransform getTransform() {
        AffineTransform at = new AffineTransform();
        Iterator iter = this.stateStack.iterator();
        while (iter.hasNext()) {
            Data d = (Data)iter.next();
            AffineTransform tf = d.transform;
            at.concatenate(tf);
        }
        at.concatenate(this.getData().transform);
        return at;
    }

    public PDFGState getGState() {
        PDFGState defaultState = PDFGState.DEFAULT;
        PDFGState newstate = new PDFGState();
        newstate.addValues(defaultState);
        Iterator iter = this.stateStack.iterator();
        while (iter.hasNext()) {
            Data d = (Data)iter.next();
            PDFGState state = d.gstate;
            if (state == null) continue;
            newstate.addValues(state);
        }
        if (this.getData().gstate != null) {
            newstate.addValues(this.getData().gstate);
        }
        return newstate;
    }

    public class Data
    implements Cloneable,
    Serializable {
        public Color color = Color.black;
        public Color backcolor = Color.black;
        public Paint paint = null;
        public Paint backPaint = null;
        public int lineCap = 0;
        public int lineJoin = 0;
        public float lineWidth = 1.0f;
        public float miterLimit = 0.0f;
        public boolean text = false;
        public int dashOffset = 0;
        public int[] dashArray = new int[0];
        public AffineTransform transform = new AffineTransform();
        public float fontSize = 0.0f;
        public String fontName = "";
        public Shape clip = null;
        public PDFGState gstate = null;
        public List concatenations = null;

        public Object clone() throws CloneNotSupportedException {
            Data obj = new Data();
            obj.color = this.color;
            obj.backcolor = this.backcolor;
            obj.paint = this.paint;
            obj.backPaint = this.paint;
            obj.lineCap = this.lineCap;
            obj.lineJoin = this.lineJoin;
            obj.lineWidth = this.lineWidth;
            obj.miterLimit = this.miterLimit;
            obj.text = this.text;
            obj.dashOffset = this.dashOffset;
            obj.dashArray = this.dashArray;
            obj.transform = new AffineTransform(this.transform);
            obj.fontSize = this.fontSize;
            obj.fontName = this.fontName;
            obj.clip = this.clip;
            obj.gstate = this.gstate;
            if (this.concatenations != null) {
                obj.concatenations = new ArrayList(this.concatenations);
            }
            return obj;
        }

        public void resetConcatenations() {
            this.concatenations = null;
        }

        public void concatenate(AffineTransform at) {
            if (this.concatenations == null) {
                this.concatenations = new ArrayList();
            }
            this.concatenations.add(at);
            this.transform.concatenate(at);
        }

        public String toString() {
            return super.toString() + ", " + this.transform + " | " + this.concatenations;
        }
    }
}

