/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DerivativeCodeGenerator {
    private DerivativeCodeGenerator() {
    }

    public static void gencodeDerivatives(Specification spec, CifCompilerContext ctxt) {
        List variables = Lists.list();
        DerivativeCodeGenerator.collectContVars((ComplexComponent)spec, variables);
        JavaCodeFile file = ctxt.addCodeFile("Derivatives");
        CodeBox h = file.header;
        h.add("/** Derivatives of all the continuous variables (excl. 'time'). */");
        h.add("public final class Derivatives {");
        CodeBox c = file.body;
        for (ContVariable var : variables) {
            if (!c.isEmpty()) {
                c.add();
            }
            c.add("public static double %s(State state) {", new Object[]{ctxt.getDerivativeMethodName(var)});
            c.indent();
            c.add("try {");
            c.indent();
            boolean found = false;
            if (var.getDerivative() != null) {
                c.add("return %s;", new Object[]{ExprCodeGenerator.gencodeExpr(var.getDerivative(), ctxt, "state")});
                found = true;
            }
            if (!found) {
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    c.add("return %s;", new Object[]{ExprCodeGenerator.gencodeExpr(eq.getValue(), ctxt, "state")});
                    found = true;
                    break;
                }
            }
            if (!found) {
                DerivativeCodeGenerator.gencodeDerivativesPerLoc(var, ctxt, c);
            }
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of the derivative of continuous variable \\\"%s\\\" failed.\", e, state);", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeDerivativesPerLoc(ContVariable var, CifCompilerContext ctxt, CodeBox c) {
        Automaton aut = (Automaton)var.eContainer();
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                c.add("case %s: return %s;", new Object[]{ctxt.getLocationValueText(loc, locIdx), ExprCodeGenerator.gencodeExpr(eq.getValue(), ctxt, "state")});
                found = true;
                break;
            }
            Assert.check((boolean)found);
            ++locIdx;
        }
        c.add("default: throw new RuntimeException(\"Invalid lp value: \" + state.%s.%s);", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.dedent();
        c.add("}");
    }

    public static void collectContVars(ComplexComponent comp, List<ContVariable> variables) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof ContVariable)) continue;
            variables.add((ContVariable)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                DerivativeCodeGenerator.collectContVars((ComplexComponent)child, variables);
            }
        }
    }
}

