/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.business.internal.refresh;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.business.api.diagramtype.SequenceDiagramTypeProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.util.NotificationQuery;

public class VisibilityEventHandler
extends ResourceSetListenerImpl {
    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (this.containsVisibilityEvent(event)) {
            throw new RollbackException((IStatus)new Status(4, "org.eclipse.sirius.diagram.sequence.ui", Messages.VisibilityEventHandler_nonSupportedHideRevealInSequenceDiagram));
        }
        return null;
    }

    private boolean containsVisibilityEvent(ResourceSetChangeEvent event) {
        Predicate<Notification> isVisibilityEvent = new Predicate<Notification>(){

            public boolean apply(Notification input) {
                NotificationQuery nq = new NotificationQuery(input);
                return nq.isViewBecomingInvisibleEvent() || nq.isHideFilterAddEvent();
            }
        };
        Predicate<Notification> isAlwaysVisibleSequenceElement = new Predicate<Notification>(){

            public boolean apply(Notification input) {
                Object notifier = input.getNotifier();
                if (notifier instanceof DDiagramElement) {
                    DDiagramElement dde = (DDiagramElement)notifier;
                    DDiagram parentDiagram = dde.getParentDiagram();
                    return parentDiagram instanceof SequenceDDiagram && !new SequenceDiagramTypeProvider().allowsHideReveal(dde);
                }
                return false;
            }
        };
        return Iterables.any((Iterable)Iterables.filter((Iterable)event.getNotifications(), Notification.class), (Predicate)Predicates.and((Predicate)isAlwaysVisibleSequenceElement, (Predicate)isVisibilityEvent));
    }
}

