/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc;

import java.util.List;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.impl.ExpressionImpl;
import org.eclipse.escet.common.java.Lists;

public class NaryExpressionConverter {
    private NaryExpressionConverter() {
    }

    public static Expression convert(Expression expr) {
        if (!(expr instanceof BinaryExpression)) {
            return expr;
        }
        BinaryExpression bexpr = (BinaryExpression)expr;
        BinaryOperator op = bexpr.getOperator();
        if (op != BinaryOperator.CONJUNCTION && op != BinaryOperator.DISJUNCTION) {
            return expr;
        }
        Expression left = NaryExpressionConverter.convert(bexpr.getLeft());
        Expression right = NaryExpressionConverter.convert(bexpr.getRight());
        NaryExpression rslt = new NaryExpression(op);
        if (left instanceof NaryExpression && ((NaryExpression)left).operator == op) {
            rslt.children.addAll(((NaryExpression)left).children);
        } else {
            rslt.children.add(left);
        }
        if (right instanceof NaryExpression && ((NaryExpression)right).operator == op) {
            rslt.children.addAll(((NaryExpression)right).children);
        } else {
            rslt.children.add(right);
        }
        return rslt;
    }

    public static class NaryExpression
    extends ExpressionImpl {
        public List<Expression> children = Lists.list();
        public final BinaryOperator operator;

        public NaryExpression(BinaryOperator operator) {
            this.operator = operator;
        }
    }
}

