/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.services;

import activity.Action;
import activity.Activity;
import activity.Claim;
import activity.Event;
import activity.Move;
import activity.PeripheralAction;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.ResourceAction;
import activity.SchedulingType;
import activity.SimpleAction;
import activity.SyncBar;
import activity.impl.ActivityQueries;
import activity.util.ActivityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import machine.IResource;
import machine.Peripheral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.CollectionUtil;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class ActivityServices {
    public static boolean isALAP(PeripheralAction action) {
        return action.getSchedulingType().equals((Object)SchedulingType.ALAP);
    }

    public static Collection<Action> getResourceActions(Activity activity, IResource resource) {
        ArrayList<Action> result = new ArrayList<Action>();
        CollectionUtil.addAll(result, (Iterable)ActivityQueries.getActionsFor((IResource)resource, ResourceAction.class, (Iterable)activity.getNodes()));
        return result;
    }

    public Collection<IResource> getResources(DSemanticDiagram element) {
        return ActivityServices.getResources((Activity)element.getTarget());
    }

    public Collection<Event> getEvents(DSemanticDiagram element) {
        return ActivityServices.getEvents((Activity)element.getTarget());
    }

    public static Collection<Event> getEvents(Activity activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return QueryableIterable.from((Iterable)activity.getNodes()).objectsOfKind(Event.class).asSet();
    }

    public static Collection<IResource> getResources(Activity activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return QueryableIterable.from((Iterable)activity.getNodes()).objectsOfKind(ResourceAction.class).xcollectOne(a -> a.getResource()).asSet();
    }

    public static Collection<IResource> getResourcePlaceholder(DSemanticDiagram element, IResource resource) {
        return ActivityServices.hasPeripherals(element, resource) ? Collections.emptyList() : Collections.singleton(resource);
    }

    public static boolean hasPeripherals(DSemanticDiagram element, IResource resource) {
        Activity activity = ActivityServices.getActivity((DSemanticDecorator)element);
        return !ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).isEmpty();
    }

    public static Collection<Peripheral> getPeripherals(DSemanticDiagram element, IResource resource) {
        return ActivityServices.getPeripherals(ActivityServices.getActivity((DSemanticDecorator)element), resource);
    }

    public static Collection<PeripheralAction> getPeripheralActions(DSemanticDecorator element, Peripheral peripheral) {
        IResource resource = ActivityServices.getResource(element);
        Activity activity = ActivityServices.getActivity(element);
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).select(a -> a.getPeripheral() == peripheral).asList();
    }

    public static IResource getResource(DSemanticDecorator element) {
        return ActivityServices.getTarget(IResource.class, element);
    }

    public static Activity getActivity(DSemanticDecorator element) {
        return ActivityServices.getTarget(Activity.class, element);
    }

    private static <T extends EObject> T getTarget(Class<T> clazz, DSemanticDecorator element) {
        while (!clazz.isInstance(element.getTarget())) {
            EObject parent = element.eContainer();
            if (!(parent instanceof DSemanticDecorator)) {
                return null;
            }
            element = (DSemanticDecorator)parent;
        }
        return (T)((EObject)clazz.cast(element.getTarget()));
    }

    public static Collection<PeripheralAction> getPeripheralActions(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).asOrderedSet();
    }

    public static Collection<Peripheral> getPeripherals(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).xcollectOne(pa -> pa.getPeripheral()).asOrderedSet();
    }

    public Collection<PeripheralAction> getPeripheralActions(DSemanticDiagram element, Activity activity) {
        return Collections.emptyList();
    }

    public Collection<Claim> getClaims(DSemanticDiagram element, IResource resource) {
        return ActivityUtil.getClaims((Activity)((Activity)element.getTarget()), (IResource)resource);
    }

    public static void addClaimRelease(Activity activity, IResource resource) {
        ActivityUtil.addClaim((Activity)activity, (IResource)resource);
        ActivityUtil.addRelease((Activity)activity, (IResource)resource);
    }

    public Collection<Release> getReleases(DSemanticDiagram element, IResource resource) {
        return ActivityUtil.getReleases((Activity)((Activity)element.getTarget()), (IResource)resource);
    }

    public String getDescription(Event event) {
        StringBuffer description = new StringBuffer(event.getName()).append(": ");
        if (event instanceof RequireEvent) {
            description.append("Require ");
        }
        if (event instanceof RaiseEvent) {
            description.append("Raise ");
        }
        description.append(event.getEventName());
        return description.toString();
    }

    public String getTooltip(Event event) {
        return this.getDescription(event);
    }

    public String getDescription(PeripheralAction action) {
        StringBuffer description = new StringBuffer(action.getName()).append(": ");
        if (action instanceof SimpleAction) {
            description.append(((SimpleAction)action).getType().getName());
        } else if (action instanceof Move) {
            description.append(MoveHelper.getDescription((Move)((Move)action), (boolean)false));
        }
        if (ActivityServices.isALAP(action)) {
            description.append(System.lineSeparator()).append("ALAP");
        }
        return description.toString();
    }

    public String getTooltip(PeripheralAction action) {
        StringBuffer description = new StringBuffer(action.getName()).append(": ");
        if (action instanceof SimpleAction) {
            description.append(action.getResource().fqn()).append('.');
            description.append(action.getPeripheral().getName()).append('.');
            description.append(((SimpleAction)action).getType().getName());
        } else if (action instanceof Move) {
            description.append(MoveHelper.getDescription((Move)((Move)action), (boolean)true));
        }
        if (ActivityServices.isALAP(action)) {
            description.append(" ").append("ALAP");
        }
        return description.toString();
    }

    public String getTooltip(SyncBar syncbar) {
        return syncbar.getName();
    }

    public String getTooltip(Claim claim) {
        StringBuffer description = new StringBuffer(claim.getName()).append(": ");
        description.append("Claim ");
        description.append(claim.getResource().fqn());
        return description.toString();
    }

    public String getTooltip(Release release) {
        StringBuffer description = new StringBuffer(release.getName()).append(": ");
        description.append("Release ");
        description.append(release.getResource().fqn());
        return description.toString();
    }

    public String getBeginLabel(Edge edge) {
        if (!(edge.getSourceNode() instanceof Action)) {
            return null;
        }
        Action action = (Action)edge.getSourceNode();
        if (action.getExit() == null) {
            return null;
        }
        StringBuffer label = new StringBuffer(action.getExit().getValue());
        if (action.getOuterExit() != null) {
            label.append("\n[").append(action.getOuterExit().getValue()).append("]");
        }
        return label.toString();
    }

    public String getEndLabel(Edge edge) {
        if (!(edge.getTargetNode() instanceof Action)) {
            return null;
        }
        Action action = (Action)edge.getTargetNode();
        if (action.getEntry() == null) {
            return null;
        }
        StringBuffer label = new StringBuffer();
        if (action.getOuterEntry() != null) {
            label.append("[").append(action.getOuterEntry().getValue()).append("]\n");
        }
        label.append(action.getEntry().getValue());
        return label.toString();
    }
}

