/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.storage;

import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutomatonData {
    public final Automaton aut;
    public final String name;
    public final Location initialLocation;
    public Map<DiscVariable, VariableData> vars;

    public AutomatonData(Automaton aut, Location initialLocation) {
        this.aut = aut;
        this.name = CifTextUtils.getAbsName((PositionObject)aut, (boolean)false);
        this.initialLocation = initialLocation;
        this.vars = null;
    }

    public void addAutomatonVars(Map<DiscVariable, VariableData> variableMap) {
        Set dvs = Sets.set();
        for (Location loc : this.aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                dvs.addAll(AutomatonData.getEdgeReadVariables(edge));
                dvs.addAll(AutomatonData.getEdgeWriteVariables(edge));
            }
        }
        this.vars = Maps.map();
        for (DiscVariable dv : dvs) {
            this.vars.put(dv, variableMap.get(dv));
        }
    }

    public Set<VariableData> getReadVariables(Edge edge) {
        Set vds = Sets.set();
        for (DiscVariable dv : AutomatonData.getEdgeReadVariables(edge)) {
            vds.add(this.vars.get(dv));
        }
        return vds;
    }

    private static Set<DiscVariable> getEdgeReadVariables(Edge edge) {
        Set dvs = Sets.set();
        for (Update upd : edge.getUpdates()) {
            Assignment asg = (Assignment)upd;
            dvs.addAll(AutomatonData.findExpressionVars(asg.getValue()));
        }
        for (Expression e : edge.getGuards()) {
            dvs.addAll(AutomatonData.findExpressionVars(e));
        }
        return dvs;
    }

    public Set<VariableData> getWriteVariables(Edge edge) {
        Set vds = Sets.set();
        for (DiscVariable dv : AutomatonData.getEdgeWriteVariables(edge)) {
            vds.add(this.vars.get(dv));
        }
        return vds;
    }

    private static Set<DiscVariable> getEdgeWriteVariables(Edge edge) {
        Set dvs = Sets.set();
        for (Update upd : edge.getUpdates()) {
            Assignment asg = (Assignment)upd;
            dvs.addAll(AutomatonData.findExpressionVars(asg.getAddressable()));
        }
        return dvs;
    }

    private static Set<DiscVariable> findExpressionVars(Expression e) {
        CifType t = CifTypeUtils.normalizeType((CifType)e.getType());
        if (t instanceof BoolType) {
            if (e instanceof BoolExpression) {
                return Sets.set();
            }
            if (e instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)e;
                Set dvs = Sets.set();
                dvs.addAll(AutomatonData.findExpressionVars(be.getLeft()));
                dvs.addAll(AutomatonData.findExpressionVars(be.getRight()));
                return dvs;
            }
            if (e instanceof UnaryExpression) {
                UnaryExpression ue = (UnaryExpression)e;
                return AutomatonData.findExpressionVars(ue.getChild());
            }
            DiscVariableExpression dve = (DiscVariableExpression)e;
            return Sets.set((Object)dve.getVariable());
        }
        Assert.check((boolean)(t instanceof IntType));
        if (e instanceof IntExpression) {
            return Sets.set();
        }
        if (e instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)e;
            Set dvs = Sets.set();
            dvs.addAll(AutomatonData.findExpressionVars(be.getLeft()));
            dvs.addAll(AutomatonData.findExpressionVars(be.getRight()));
            return dvs;
        }
        if (e instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)e;
            return AutomatonData.findExpressionVars(ue.getChild());
        }
        DiscVariableExpression dve = (DiscVariableExpression)e;
        return Sets.set((Object)dve.getVariable());
    }

    public Set<Event> getEvents(Edge edge) {
        Set events = Sets.set();
        for (EdgeEvent ee : edge.getEvents()) {
            EventExpression e = (EventExpression)ee.getEvent();
            Event evt = e.getEvent();
            Assert.notNull((Object)evt);
            events.add(evt);
        }
        return events;
    }

    public Set<Event> getAlphabet() {
        return CifEventUtils.getAlphabet((Automaton)this.aut);
    }
}

