/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.markers;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.genericeditor.markers.MarkerResolutionCompletionProposal;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class MarkerResoltionQuickAssistProcessor
implements IQuickAssistProcessor {
    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return annotation instanceof MarkerAnnotation;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        IAnnotationModel annotationModel = invocationContext.getSourceViewer().getAnnotationModel();
        HashSet annotations = new HashSet();
        annotationModel.getAnnotationIterator().forEachRemaining(annotation -> {
            Position position = annotationModel.getPosition(annotation);
            if (invocationContext.getOffset() >= position.getOffset() && invocationContext.getOffset() + Math.max(0, invocationContext.getLength()) <= position.getOffset() + position.getLength() && annotation instanceof MarkerAnnotation) {
                annotations.add((MarkerAnnotation)annotation);
            }
        });
        ArrayList<MarkerResolutionCompletionProposal> resolutions = new ArrayList<MarkerResolutionCompletionProposal>();
        for (MarkerAnnotation annotation2 : annotations) {
            IMarker marker = annotation2.getMarker();
            IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(marker);
            int n = iMarkerResolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution resolution = iMarkerResolutionArray[n2];
                resolutions.add(new MarkerResolutionCompletionProposal(marker, resolution));
                ++n2;
            }
        }
        return resolutions.toArray(new ICompletionProposal[resolutions.size()]);
    }
}

