/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator;

import java.util.List;
import org.eclipse.escet.cif.simulator.CifSimulator;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.options.AskToTerminateOption;
import org.eclipse.escet.cif.simulator.options.AutoAlgoOption;
import org.eclipse.escet.cif.simulator.options.AutoTimeDurationOption;
import org.eclipse.escet.cif.simulator.options.CifSpecInitOption;
import org.eclipse.escet.cif.simulator.options.CifSpecOption;
import org.eclipse.escet.cif.simulator.options.CompileOnlyOption;
import org.eclipse.escet.cif.simulator.options.CompiledCodeFileOption;
import org.eclipse.escet.cif.simulator.options.CompleteModeOption;
import org.eclipse.escet.cif.simulator.options.DebugCodeOption;
import org.eclipse.escet.cif.simulator.options.DistributionSeedOption;
import org.eclipse.escet.cif.simulator.options.EndTimeOption;
import org.eclipse.escet.cif.simulator.options.EnvironmentEventsOption;
import org.eclipse.escet.cif.simulator.options.ExtFuncAsyncOption;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.HistoryOption;
import org.eclipse.escet.cif.simulator.options.HistorySizeOption;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.options.InteractiveAutoChooseOption;
import org.eclipse.escet.cif.simulator.options.MaxDelayOption;
import org.eclipse.escet.cif.simulator.options.MaxTimePointTolOption;
import org.eclipse.escet.cif.simulator.options.ProfilingOption;
import org.eclipse.escet.cif.simulator.options.SimulationSpeedOption;
import org.eclipse.escet.cif.simulator.options.TestModeOption;
import org.eclipse.escet.cif.simulator.options.TraceInputFileOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputStateFiltersOption;
import org.eclipse.escet.cif.simulator.output.SimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.SimulatorOutputProvider;
import org.eclipse.escet.cif.simulator.output.SimulatorStreamOutputComponent;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerOutputComponent;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizerOutputComponent;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgOutputComponent;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataOutputComponent;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorAbsTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorAlgoOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorMaxStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorMinStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorNumStepsOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorRelTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeSolverOutStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderAbsTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderAlgoOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderMaxCheckOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderMaxIterOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderRelTolOption;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.javacompiler.JavaCompilerOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;

public class CifSimulatorApp
extends Application<SimulatorOutputComponent> {
    public static void main(String[] args) {
        CifSimulatorApp app = new CifSimulatorApp();
        app.run(args);
    }

    public CifSimulatorApp() {
    }

    public CifSimulatorApp(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<SimulatorOutputComponent> getProvider() {
        return new SimulatorOutputProvider();
    }

    protected IOutputComponent getStreamOutputComponent(AppStream out, AppStream err) {
        return new SimulatorStreamOutputComponent(out, err);
    }

    public String getAppName() {
        return "CIF simulator";
    }

    public String getAppDescription() {
        return "The simulator can be used to explore the state space of CIF specifications, either interactively, or using a more automated approach. Powerful visualization features allow for interactive visualization based validation of the CIF specification.";
    }

    protected int runInternal() {
        CifSimulatorContext ctxt = new CifSimulatorContext(this.getAppEnvData());
        CifSimulator simulator = new CifSimulator(ctxt);
        simulator.simulate(this);
        return 0;
    }

    protected OptionCategory getAllOptions() {
        OptionCategory genCat = CifSimulatorApp.getGeneralOptionCategory();
        List simOpts = Lists.list();
        simOpts.add(Options.getInstance(CifSpecOption.class));
        simOpts.add(Options.getInstance(CifSpecInitOption.class));
        simOpts.add(Options.getInstance(EndTimeOption.class));
        simOpts.add(Options.getInstance(MaxDelayOption.class));
        simOpts.add(Options.getInstance(DistributionSeedOption.class));
        simOpts.add(Options.getInstance(CompleteModeOption.class));
        simOpts.add(Options.getInstance(ExtFuncAsyncOption.class));
        simOpts.add(Options.getInstance(ProfilingOption.class));
        simOpts.add(Options.getInstance(AskToTerminateOption.class));
        simOpts.add(Options.getInstance(MaxTimePointTolOption.class));
        simOpts.add(Options.getInstance(DebugCodeOption.class));
        List simSubCats = Lists.list();
        OptionCategory simCat = new OptionCategory("Simulator", "Simulator options.", simSubCats, simOpts);
        List compileOpts = Lists.list();
        compileOpts.add(Options.getInstance(CompileOnlyOption.class));
        compileOpts.add(Options.getInstance(CompiledCodeFileOption.class));
        compileOpts.add(Options.getInstance(JavaCompilerOption.class));
        List compileSubCats = Lists.list();
        OptionCategory compileCat = new OptionCategory("Compiler", "Compiler options.", compileSubCats, compileOpts);
        List inOpts = Lists.list();
        inOpts.add(Options.getInstance(InputModeOption.class));
        inOpts.add(Options.getInstance(AutoAlgoOption.class));
        inOpts.add(Options.getInstance(AutoTimeDurationOption.class));
        inOpts.add(Options.getInstance(TraceInputFileOption.class));
        inOpts.add(Options.getInstance(InteractiveAutoChooseOption.class));
        inOpts.add(Options.getInstance(EnvironmentEventsOption.class));
        inOpts.add(Options.getInstance(HistoryOption.class));
        inOpts.add(Options.getInstance(HistorySizeOption.class));
        List inSubCats = Lists.list();
        OptionCategory inCat = new OptionCategory("Input", "Input mode options.", inSubCats, inOpts);
        List outOpts = Lists.list();
        outOpts.add(Options.getInstance(NormalOutputOption.class));
        outOpts.add(Options.getInstance(NormalOutputStateFiltersOption.class));
        outOpts.add(Options.getInstance(DebugOutputOption.class));
        outOpts.add(Options.getInstance(FrameRateOption.class));
        outOpts.add(Options.getInstance(SimulationSpeedOption.class));
        outOpts.add(Options.getInstance(TestModeOption.class));
        List outSubCats = Lists.list();
        outSubCats.add(SvgOutputComponent.getOptions());
        outSubCats.add(TrajDataOutputComponent.getOptions());
        outSubCats.add(PlotVisualizerOutputComponent.getOptions());
        outSubCats.add(StateVisualizerOutputComponent.getOptions());
        OptionCategory outCat = new OptionCategory("Output", "Output options.", outSubCats, outOpts);
        List intOpts = Lists.list();
        intOpts.add(Options.getInstance(IntegratorAlgoOption.class));
        intOpts.add(Options.getInstance(IntegratorAbsTolOption.class));
        intOpts.add(Options.getInstance(IntegratorRelTolOption.class));
        intOpts.add(Options.getInstance(IntegratorMinStepOption.class));
        intOpts.add(Options.getInstance(IntegratorMaxStepOption.class));
        intOpts.add(Options.getInstance(IntegratorNumStepsOption.class));
        List intSubCats = Lists.list();
        OptionCategory intCat = new OptionCategory("ODE integrator", "ODE solver integrator options.", intSubCats, intOpts);
        List rootOpts = Lists.list();
        rootOpts.add(Options.getInstance(RootFinderMaxCheckOption.class));
        rootOpts.add(Options.getInstance(RootFinderAlgoOption.class));
        rootOpts.add(Options.getInstance(RootFinderAbsTolOption.class));
        rootOpts.add(Options.getInstance(RootFinderRelTolOption.class));
        rootOpts.add(Options.getInstance(RootFinderMaxIterOption.class));
        List rootSubCats = Lists.list();
        OptionCategory rootCat = new OptionCategory("ODE root finder", "ODE solver root finder options.", rootSubCats, rootOpts);
        List odeOpts = Lists.list();
        odeOpts.add(Options.getInstance(OdeSolverOutStepOption.class));
        List odeSubCats = Lists.list((Object[])new OptionCategory[]{intCat, rootCat});
        OptionCategory odeCat = new OptionCategory("ODE solver", "ODE solver options.", odeSubCats, odeOpts);
        return new OptionCategory("CIF Simulator Options", "All options for the CIF simulator.", Lists.list((Object[])new OptionCategory[]{genCat, simCat, compileCat, inCat, outCat, odeCat}), Lists.list());
    }
}

