/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateInitOrderer
extends DependencyOrderer<PositionObject> {
    protected Set<PositionObject> findDirectDependencies(PositionObject obj) {
        if (obj instanceof Declaration) {
            Object values;
            if (obj instanceof DiscVariable) {
                DiscVariable dvar = (DiscVariable)obj;
                if (dvar.getValue() == null) {
                    return Sets.set();
                }
                values = dvar.getValue().getValues();
                if (values == null) {
                    return Sets.set();
                }
            } else {
                ContVariable cvar = (ContVariable)obj;
                if (cvar.getValue() == null) {
                    return Sets.set();
                }
                values = Lists.list((Object)cvar.getValue());
            }
            Set rslt = Sets.set();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Expression value = (Expression)iterator.next();
                StateInitOrderer.collectDependencies(value, rslt);
            }
            return rslt;
        }
        if (obj instanceof Automaton) {
            Automaton aut = (Automaton)obj;
            Set rslt = Sets.set();
            for (Location loc : aut.getLocations()) {
                if (loc.getInitials().isEmpty()) continue;
                rslt.add(loc);
            }
            return rslt;
        }
        if (obj instanceof Location) {
            Location loc = (Location)obj;
            Set rslt = Sets.set();
            for (Expression init : loc.getInitials()) {
                StateInitOrderer.collectDependencies(init, rslt);
            }
            return rslt;
        }
        throw new RuntimeException("Unexpected obj: " + obj);
    }

    private static void collectDependencies(Expression expr, Set<PositionObject> deps) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof TimeExpression) {
            return;
        }
        if (expr instanceof CastExpression) {
            StateInitOrderer.collectDependencies(((CastExpression)expr).getChild(), deps);
            return;
        }
        if (expr instanceof UnaryExpression) {
            StateInitOrderer.collectDependencies(((UnaryExpression)expr).getChild(), deps);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            StateInitOrderer.collectDependencies(bexpr.getLeft(), deps);
            StateInitOrderer.collectDependencies(bexpr.getRight(), deps);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression iexpr = (IfExpression)expr;
            for (Expression guard : iexpr.getGuards()) {
                StateInitOrderer.collectDependencies(guard, deps);
            }
            StateInitOrderer.collectDependencies(iexpr.getThen(), deps);
            for (ElifExpression elif : iexpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    StateInitOrderer.collectDependencies(guard, deps);
                }
                StateInitOrderer.collectDependencies(elif.getThen(), deps);
            }
            StateInitOrderer.collectDependencies(iexpr.getElse(), deps);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sexpr = (SwitchExpression)expr;
            StateInitOrderer.collectDependencies(sexpr.getValue(), deps);
            for (SwitchCase cse : sexpr.getCases()) {
                if (cse.getKey() != null) {
                    StateInitOrderer.collectDependencies(cse.getKey(), deps);
                }
                StateInitOrderer.collectDependencies(cse.getValue(), deps);
            }
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            StateInitOrderer.collectDependencies(pexpr.getChild(), deps);
            StateInitOrderer.collectDependencies(pexpr.getIndex(), deps);
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            StateInitOrderer.collectDependencies(sexpr.getChild(), deps);
            if (sexpr.getBegin() != null) {
                StateInitOrderer.collectDependencies(sexpr.getBegin(), deps);
            }
            if (sexpr.getEnd() != null) {
                StateInitOrderer.collectDependencies(sexpr.getEnd(), deps);
            }
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            for (Expression param : fexpr.getParams()) {
                StateInitOrderer.collectDependencies(param, deps);
            }
            StateInitOrderer.collectDependencies(fexpr.getFunction(), deps);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                StateInitOrderer.collectDependencies(elem, deps);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                StateInitOrderer.collectDependencies(elem, deps);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                StateInitOrderer.collectDependencies(field, deps);
            }
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                StateInitOrderer.collectDependencies(pair.getKey(), deps);
                StateInitOrderer.collectDependencies(pair.getValue(), deps);
            }
            return;
        }
        if (expr instanceof ConstantExpression) {
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            return;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            deps.add((PositionObject)var);
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression value : values) {
                StateInitOrderer.collectDependencies(value, deps);
            }
            return;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = ((ContVariableExpression)expr).getVariable();
            if (cexpr.isDerivative()) {
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression deriv : derivs) {
                    StateInitOrderer.collectDependencies(deriv, deps);
                }
                return;
            }
            deps.add((PositionObject)var);
            return;
        }
        if (expr instanceof InputVariableExpression) {
            return;
        }
        if (expr instanceof LocationExpression) {
            Location loc = ((LocationExpression)expr).getLocation();
            deps.add((PositionObject)loc);
            return;
        }
        if (expr instanceof ComponentExpression) {
            Component comp = ((ComponentExpression)expr).getComponent();
            if (!(comp instanceof Automaton)) {
                throw new RuntimeException("comp ref as value: " + comp);
            }
            deps.add((PositionObject)comp);
            return;
        }
        if (expr instanceof SelfExpression) {
            CifType ctype = CifTypeUtils.normalizeType(expr.getType());
            deps.add((PositionObject)((ComponentType)ctype).getComponent());
            return;
        }
        throw new RuntimeException("Unexpected expr: " + expr);
    }
}

