/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.texteditorbase.RuleBasedScannerEx;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RegExRule
implements IRule {
    private final Pattern pattern;
    private final IToken token;

    public RegExRule(String pattern, IToken token) {
        this.pattern = Pattern.compile(pattern);
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (!(scanner instanceof RuleBasedScannerEx)) {
            String msg = Strings.fmt((String)"Scanner class %s must implement %s in order for %s rules to be added to it.", (Object[])new Object[]{scanner.getClass().getName(), RuleBasedScannerEx.class.getName(), RegExRule.class.getName()});
            throw new RuntimeException(msg);
        }
        RuleBasedScannerEx scanner2 = (RuleBasedScannerEx)scanner;
        DocumentCharSequence cs = new DocumentCharSequence(scanner2.getInternalDocument(), scanner2.getInternalOffset(), scanner2.getInternalLength());
        Matcher matcher = this.pattern.matcher(cs);
        boolean match = matcher.lookingAt();
        if (match) {
            int length = matcher.end() - matcher.start();
            int i = 0;
            while (i < length) {
                int c = scanner.read();
                Assert.check((c != -1 ? 1 : 0) != 0);
                ++i;
            }
        }
        return match ? this.token : Token.UNDEFINED;
    }

    public static class DocumentCharSequence
    implements CharSequence {
        private final IDocument document;
        private final int offset;
        private final int length;

        public DocumentCharSequence(IDocument document, int offset, int length) {
            Assert.check((offset >= 0 ? 1 : 0) != 0);
            Assert.check((length >= 0 ? 1 : 0) != 0);
            Assert.check((offset + length <= document.getLength() ? 1 : 0) != 0);
            this.document = document;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            Assert.check((index >= 0 ? 1 : 0) != 0);
            Assert.check((index < this.length ? 1 : 0) != 0);
            try {
                return this.document.getChar(this.offset + index);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            Assert.check((start >= 0 ? 1 : 0) != 0);
            Assert.check((start < this.length ? 1 : 0) != 0);
            Assert.check((start <= end ? 1 : 0) != 0);
            Assert.check((end <= this.length ? 1 : 0) != 0);
            return new DocumentCharSequence(this.document, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            try {
                return this.document.get(this.offset, this.length);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

