/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;

public abstract class AbstractJavaContext {
    private final String uri;
    private final ITypeRoot typeRoot;
    private final JDTUtils utils;
    private Map<String, Object> cache;
    private CompilationUnit fASTRoot;

    public AbstractJavaContext(String uri, ITypeRoot typeRoot, JDTUtils utils) {
        this.uri = uri;
        this.typeRoot = typeRoot;
        this.utils = utils;
        this.fASTRoot = null;
    }

    public String getUri() {
        return this.uri;
    }

    public ITypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public IJavaProject getJavaProject() {
        return this.getTypeRoot().getJavaProject();
    }

    public JDTUtils getUtils() {
        return this.utils;
    }

    public void put(String key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        this.cache.put(key, value);
    }

    public Object get(String key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(key);
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)this.getTypeRoot()), null);
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }
}

