/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix.RemoveAnnotationConflictQuickFix;

public abstract class RemoveMultipleAnnotations
extends RemoveAnnotationConflictQuickFix {
    public RemoveMultipleAnnotations() {
        super(new String[0]);
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        JsonArray diagnosticData = (JsonArray)diagnostic.getData();
        List<String> annotations = IntStream.range(0, diagnosticData.size()).mapToObj(idx -> diagnosticData.get(idx).getAsString()).collect(Collectors.toList());
        if (parentType != null) {
            ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
            List<List<String>> annotationsListsToRemove = this.getMultipleRemoveAnnotations(annotations);
            for (List<String> annotationList : annotationsListsToRemove) {
                String[] annotationsToRemove = annotationList.toArray(new String[annotationList.size()]);
                RemoveMultipleAnnotations.removeAnnotation(diagnostic, context, parentType, codeActions, annotationsToRemove);
            }
            return codeActions;
        }
        return null;
    }

    protected abstract List<List<String>> getMultipleRemoveAnnotations(List<String> var1);
}

