/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.NewAnnotationProposal;

public class InsertAnnotationMissingQuickFix
implements IJavaCodeActionParticipant {
    private final String[] annotations;
    private final boolean generateOnlyOneCodeAction;

    public InsertAnnotationMissingQuickFix(String ... annotations) {
        this(false, annotations);
    }

    public InsertAnnotationMissingQuickFix(boolean generateOnlyOneCodeAction, String ... annotations) {
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.annotations = annotations;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        IBinding parentType = InsertAnnotationMissingQuickFix.getBinding(node);
        if (parentType != null) {
            ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
            this.insertAnnotations(diagnostic, context, parentType, codeActions);
            return codeActions;
        }
        return null;
    }

    protected static IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)node.getParent();
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)node.getParent();
            return methodDecl.resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }

    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            InsertAnnotationMissingQuickFix.insertAnnotation(diagnostic, context, parentType, codeActions, this.annotations);
        } else {
            String[] stringArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                InsertAnnotationMissingQuickFix.insertAnnotation(diagnostic, context, parentType, codeActions, annotation);
                ++n2;
            }
        }
    }

    protected static void insertAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String ... annotations) throws CoreException {
        String name = InsertAnnotationMissingQuickFix.getLabel(annotations);
        NewAnnotationProposal proposal = new NewAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotations);
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    private static String getLabel(String[] annotations) {
        StringBuilder name = new StringBuilder("Insert ");
        int i = 0;
        while (i < annotations.length) {
            String annotation = annotations[i];
            String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
            if (i > 0) {
                name.append(", ");
            }
            name.append("@");
            name.append(annotationName);
            ++i;
        }
        return name.toString();
    }
}

