/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.di;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class MultipleConstructorInjectTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void multipleInject() throws Exception {
        IJavaProject javaProject = MultipleConstructorInjectTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/MultipleConstructorWithInject.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 11, 40, "The annotation @Inject must not define more than one constructor.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInject");
        Diagnostic d2 = JakartaForJavaAssert.d(26, 11, 40, "The annotation @Inject must not define more than one constructor.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInject");
        Diagnostic d3 = JakartaForJavaAssert.d(31, 14, 43, "The annotation @Inject must not define more than one constructor.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInject");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, JDT_UTILS, d1, d2, d3);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(21, 4, 22, 4, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d1, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, JDT_UTILS, ca);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        TextEdit te2 = JakartaForJavaAssert.te(30, 4, 31, 4, "");
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove @Inject", d3, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, JDT_UTILS, ca2);
    }
}

