/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ChangeCorrectionProposal;

public class DeleteAnnotationProposal
extends ChangeCorrectionProposal {
    private final CompilationUnit fInvocationNode;
    private final IBinding fBinding;
    private final String[] annotations;
    private final ASTNode declaringNode;

    public DeleteAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, ASTNode declaringNode, String ... annotations) {
        super(label, "quickfix", targetCU, null, relevance);
        this.fInvocationNode = invocationNode;
        this.fBinding = binding;
        this.declaringNode = declaringNode;
        this.annotations = annotations;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode declNode = this.declaringNode;
        ASTNode boundNode = this.fInvocationNode.findDeclaringNode(this.fBinding);
        CompilationUnit newRoot = this.fInvocationNode;
        if (boundNode == null) {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        if (declNode instanceof VariableDeclarationFragment) {
            declNode = declNode.getParent();
        }
        boolean isField = declNode instanceof FieldDeclaration;
        boolean isMethod = declNode instanceof MethodDeclaration;
        boolean isType = declNode instanceof TypeDeclaration;
        String[] annotations = this.getAnnotations();
        String[] annotationShortNames = new String[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            String shortName;
            annotationShortNames[i] = shortName = annotations[i].substring(annotations[i].lastIndexOf(".") + 1, annotations[i].length());
            ++i;
        }
        if (isField || isMethod || isType) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            new ContextSensitiveImportRewriteContext(declNode, imports);
            List children = isMethod ? (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS2_PROPERTY) : (isType ? (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS2_PROPERTY) : (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY));
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                boolean containsAnnotation = Arrays.stream(annotationShortNames).anyMatch(annotation.getTypeName().toString()::equals);
                if (!containsAnnotation) continue;
                rewrite.remove(child, null);
            }
            return rewrite;
        }
        return null;
    }

    protected CompilationUnit getInvocationNode() {
        return this.fInvocationNode;
    }

    protected IBinding getBinding() {
        return this.fBinding;
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }
}

