/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.jsonp;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.ASTUtils;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class JsonpDiagnosticCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-jsonp";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit == null) {
            return;
        }
        List<MethodInvocation> allMethodInvocations = ASTUtils.getMethodInvocations(unit);
        List createPointerInvocations = allMethodInvocations.stream().filter(mi -> {
            try {
                return this.isMatchedJsonCreatePointer(unit, (MethodInvocation)mi);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }).collect(Collectors.toList());
        for (MethodInvocation m : createPointerInvocations) {
            Expression arg = (Expression)m.arguments().get(0);
            if (!this.isInvalidArgument(arg)) continue;
            try {
                Range range = JDTUtils.toRange((IOpenable)unit, arg.getStartPosition(), arg.getLength());
                Diagnostic diagnostic = new Diagnostic(range, "Json.createPointer target must be a sequence of '/' prefixed tokens or an empty String");
                this.completeDiagnostic(diagnostic, "InvalidCreatePointerArg");
                diagnostics.add(diagnostic);
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }

    private boolean isInvalidArgument(Expression arg) {
        String argValue;
        return arg instanceof StringLiteral && !(argValue = ((StringLiteral)arg).getLiteralValue()).isEmpty() && !argValue.matches("^(\\/[^\\/]+)+$");
    }

    private boolean isMatchedJsonCreatePointer(ICompilationUnit unit, MethodInvocation mi) throws JavaModelException {
        Expression ex;
        String qualifier;
        if (mi.arguments().size() == 1 && "createPointer".equals(mi.getName().getIdentifier()) && mi.getExpression() != null && "jakarta.json.Json".endsWith(qualifier = (ex = mi.getExpression()).toString())) {
            if (JsonpDiagnosticCollector.isImportedJavaElement(unit, "jakarta.json.Json")) {
                return true;
            }
            if ("jakarta.json.Json".equals(qualifier)) {
                ITypeBinding itb = ex.resolveTypeBinding();
                return itb != null && qualifier.equals(itb.getQualifiedName());
            }
        }
        return false;
    }
}

