/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.persistence.PersistenceConstants;

public class PersistenceMapKeyDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-persistence";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String matchedAnnotation;
                    IAnnotation annotation;
                    int n3;
                    int n4;
                    IAnnotation[] iAnnotationArray;
                    IAnnotation[] allAnnotations;
                    boolean hasMapKeyClassAnnotation;
                    boolean hasMapKeyAnnotation;
                    ArrayList<IAnnotation> mapKeyJoinCols;
                    IMethod[] methods;
                    IType type = iTypeArray[n2];
                    IMethod[] iMethodArray = methods = type.getMethods();
                    int n5 = methods.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMethod method = iMethodArray[n6];
                        mapKeyJoinCols = new ArrayList<IAnnotation>();
                        hasMapKeyAnnotation = false;
                        hasMapKeyClassAnnotation = false;
                        iAnnotationArray = allAnnotations = method.getAnnotations();
                        n4 = allAnnotations.length;
                        n3 = 0;
                        while (n3 < n4) {
                            annotation = iAnnotationArray[n3];
                            matchedAnnotation = PersistenceMapKeyDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), PersistenceConstants.SET_OF_PERSISTENCE_ANNOTATIONS);
                            if (matchedAnnotation != null) {
                                if ("jakarta.persistence.MapKey".equals(matchedAnnotation)) {
                                    hasMapKeyAnnotation = true;
                                } else if ("jakarta.persistence.MapKeyClass".equals(matchedAnnotation)) {
                                    hasMapKeyClassAnnotation = true;
                                } else if ("jakarta.persistence.MapKeyJoinColumn".equals(matchedAnnotation)) {
                                    mapKeyJoinCols.add(annotation);
                                }
                            }
                            ++n3;
                        }
                        if (hasMapKeyAnnotation && hasMapKeyClassAnnotation) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "@MapKeyClass and @MapKey annotations cannot be used on the same field or property", "RemoveMapKeyorMapKeyClass", null, DiagnosticSeverity.Error));
                        }
                        if (mapKeyJoinCols.size() > 1) {
                            this.validateMapKeyJoinColumnAnnotations(mapKeyJoinCols, (IMember)method, unit, diagnostics);
                        }
                        ++n6;
                    }
                    IField[] fields = type.getFields();
                    iMethodArray = fields;
                    n5 = fields.length;
                    n6 = 0;
                    while (n6 < n5) {
                        IMethod field = iMethodArray[n6];
                        mapKeyJoinCols = new ArrayList();
                        hasMapKeyAnnotation = false;
                        hasMapKeyClassAnnotation = false;
                        iAnnotationArray = allAnnotations = field.getAnnotations();
                        n4 = allAnnotations.length;
                        n3 = 0;
                        while (n3 < n4) {
                            annotation = iAnnotationArray[n3];
                            matchedAnnotation = PersistenceMapKeyDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), PersistenceConstants.SET_OF_PERSISTENCE_ANNOTATIONS);
                            if (matchedAnnotation != null) {
                                if ("jakarta.persistence.MapKey".equals(matchedAnnotation)) {
                                    hasMapKeyAnnotation = true;
                                } else if ("jakarta.persistence.MapKeyClass".equals(matchedAnnotation)) {
                                    hasMapKeyClassAnnotation = true;
                                } else if ("jakarta.persistence.MapKeyJoinColumn".equals(matchedAnnotation)) {
                                    mapKeyJoinCols.add(annotation);
                                }
                            }
                            ++n3;
                        }
                        if (hasMapKeyAnnotation && hasMapKeyClassAnnotation) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, "@MapKeyClass and @MapKey annotations cannot be used on the same field or property", "RemoveMapKeyorMapKeyClass", null, DiagnosticSeverity.Error));
                        }
                        if (mapKeyJoinCols.size() > 1) {
                            this.validateMapKeyJoinColumnAnnotations(mapKeyJoinCols, (IMember)field, unit, diagnostics);
                        }
                        ++n6;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }

    private void validateMapKeyJoinColumnAnnotations(List<IAnnotation> annotations, IMember element, ICompilationUnit unit, List<Diagnostic> diagnostics) {
        String prefix = element instanceof IMethod ? "A method " : "A field ";
        annotations.forEach(annotation -> {
            try {
                List<IMemberValuePair> memberValues = Arrays.asList(annotation.getMemberValuePairs());
                boolean allNamesSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("name"));
                boolean allReferencedColumnNameSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("referencedColumnName"));
                if (!allNamesSpecified || !allReferencedColumnNameSpecified) {
                    diagnostics.add(this.createDiagnostic((IJavaElement)element, unit, String.valueOf(prefix) + "with multiple @MapKeyJoinColumn annotations must specify both the name and referencedColumnName attributes in the corresponding @MapKeyJoinColumn annotations.", "SupplyAttributesToAnnotations", null, DiagnosticSeverity.Error));
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Error while retrieving member values of @MapKeyJoinColumn Annotation", e);
            }
        });
    }
}

