/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.openapi.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Test;

public class GenerateOpenAPIAnnotationsTest
extends BasePropertiesManagerTest {
    @Test
    public void GenerateOpenAPIAnnotationsAction() throws Exception {
        IJavaProject javaProject = GenerateOpenAPIAnnotationsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_openapi);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/openapi/NoOperationAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        Diagnostic d = new Diagnostic();
        Position start = new Position(8, 23);
        d.setRange(new Range(start, start));
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d);
        String newText = "\n\nimport org.eclipse.microprofile.openapi.annotations.Operation;\n\n@RequestScoped\n@Path(\"/systems\")\npublic class NoOperationAnnotation {\n\n\t@Operation(summary = \"\", description = \"\")\n\t@GET\n\tpublic Response getMyInformation(String hostname) {\n\t\treturn Response.ok(listContents()).build();\n\t}\n\n\t@Operation(summary = \"\", description = \"\")\n\t";
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Generate OpenAPI Annotations for 'NoOperationAnnotation'", d, MicroProfileForJavaAssert.te(6, 33, 17, 1, newText)));
    }
}

