/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.Arrays;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

class CompositeContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private final IContextInformationValidator[] children;

    public CompositeContextInformationValidator(IContextInformationValidator[] validators) {
        this.children = validators;
    }

    @Override
    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        Arrays.stream(this.children).forEach(child -> child.install(info, viewer, offset));
    }

    @Override
    public boolean isContextInformationValid(int offset) {
        return Arrays.stream(this.children).anyMatch(child -> child.isContextInformationValid(offset));
    }

    @Override
    public boolean updatePresentation(int offset, TextPresentation presentation) {
        if (this.children.length == 1 && this.children[0] instanceof IContextInformationPresenter) {
            return ((IContextInformationPresenter)((Object)this.children[0])).updatePresentation(offset, presentation);
        }
        return false;
    }
}

