/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SegmentDocValuesProducer;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.internal.tests.SegmentReaderAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;

public final class SegmentReader
extends CodecReader {
    private final SegmentCommitInfo si;
    private final SegmentCommitInfo originalSi;
    private final LeafMetaData metaData;
    private final Bits liveDocs;
    private final Bits hardLiveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final boolean isNRT;
    final DocValuesProducer docValuesProducer;
    final FieldInfos fieldInfos;
    private final Set<IndexReader.ClosedListener> readerClosedListeners = new CopyOnWriteArraySet<IndexReader.ClosedListener>();
    private final IndexReader.CacheHelper readerCacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            SegmentReader.this.ensureOpen();
            SegmentReader.this.readerClosedListeners.add(listener);
        }
    };
    private final IndexReader.CacheHelper coreCacheHelper = new IndexReader.CacheHelper(){

        @Override
        public IndexReader.CacheKey getKey() {
            return SegmentReader.this.core.getCacheHelper().getKey();
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            SegmentReader.this.ensureOpen();
            SegmentReader.this.core.getCacheHelper().addClosedListener(listener);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo si, int createdVersionMajor, IOContext context) throws IOException {
        this.si = si.clone();
        this.originalSi = si;
        this.metaData = new LeafMetaData(createdVersionMajor, si.info.getMinVersion(), si.info.getIndexSort());
        this.isNRT = false;
        this.core = new SegmentCoreReaders(si.info.dir, si, context);
        this.segDocValues = new SegmentDocValues();
        boolean success = false;
        Codec codec = si.info.getCodec();
        try {
            if (si.hasDeletions()) {
                this.hardLiveDocs = this.liveDocs = codec.liveDocsFormat().readLiveDocs(this.directory(), si, IOContext.READONCE);
            } else {
                assert (si.getDelCount() == 0);
                this.liveDocs = null;
                this.hardLiveDocs = null;
            }
            this.numDocs = si.info.maxDoc() - si.getDelCount();
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            assert (SegmentReader.assertLiveDocs(this.isNRT, this.hardLiveDocs, this.liveDocs));
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo si, SegmentReader sr, Bits liveDocs, Bits hardLiveDocs, int numDocs, boolean isNRT) throws IOException {
        if (numDocs > si.info.maxDoc()) {
            throw new IllegalArgumentException("numDocs=" + numDocs + " but maxDoc=" + si.info.maxDoc());
        }
        if (liveDocs != null && liveDocs.length() != si.info.maxDoc()) {
            throw new IllegalArgumentException("maxDoc=" + si.info.maxDoc() + " but liveDocs.size()=" + liveDocs.length());
        }
        this.si = si.clone();
        this.originalSi = si;
        this.metaData = sr.getMetaData();
        this.liveDocs = liveDocs;
        this.hardLiveDocs = hardLiveDocs;
        assert (SegmentReader.assertLiveDocs(isNRT, hardLiveDocs, liveDocs));
        this.isNRT = isNRT;
        this.numDocs = numDocs;
        this.core = sr.core;
        this.core.incRef();
        this.segDocValues = sr.segDocValues;
        boolean success = false;
        try {
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private static boolean assertLiveDocs(boolean isNRT, Bits hardLiveDocs, Bits liveDocs) {
        if (isNRT) {
            assert (hardLiveDocs == null || liveDocs != null) : " liveDocs must be non null if hardLiveDocs are non null";
        } else assert (hardLiveDocs == liveDocs) : "non-nrt case must have identical liveDocs";
        return true;
    }

    private DocValuesProducer initDocValuesProducer() throws IOException {
        if (!this.fieldInfos.hasDocValues()) {
            return null;
        }
        Directory dir = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        if (this.si.hasFieldUpdates()) {
            return new SegmentDocValuesProducer(this.si, dir, this.core.coreFieldInfos, this.fieldInfos, this.segDocValues);
        }
        return this.segDocValues.getDocValuesProducer(-1L, this.si, dir, this.fieldInfos);
    }

    private FieldInfos initFieldInfos() throws IOException {
        if (!this.si.hasFieldUpdates()) {
            return this.core.coreFieldInfos;
        }
        FieldInfosFormat fisFormat = this.si.info.getCodec().fieldInfosFormat();
        String segmentSuffix = Long.toString(this.si.getFieldInfosGen(), 36);
        return fisFormat.read(this.si.info.dir, this.si.info, segmentSuffix, IOContext.READONCE);
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    @Override
    protected void doClose() throws IOException {
        try {
            this.core.decRef();
        }
        finally {
            if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
            } else if (this.docValuesProducer != null) {
                this.segDocValues.decRef(Collections.singletonList(-1L));
            }
        }
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.si.info.maxDoc();
    }

    @Override
    public final void document(int docID, StoredFieldVisitor visitor) throws IOException {
        Objects.checkIndex(docID, this.maxDoc());
        this.getThreadLocalFieldsReader().document(docID, visitor);
    }

    @Override
    public final Fields getTermVectors(int docID) throws IOException {
        Objects.checkIndex(docID, this.maxDoc());
        TermVectorsReader termVectorsReader = this.getThreadLocalTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docID);
    }

    @Deprecated
    private TermVectorsReader getThreadLocalTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    @Deprecated
    private StoredFieldsReader getThreadLocalFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        this.ensureOpen();
        if (this.core.termVectorsReaderOrig == null) {
            return null;
        }
        return this.core.termVectorsReaderOrig.clone();
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderOrig.clone();
    }

    @Override
    public PointsReader getPointsReader() {
        this.ensureOpen();
        return this.core.pointsReader;
    }

    @Override
    public NormsProducer getNormsReader() {
        this.ensureOpen();
        return this.core.normsProducer;
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        this.ensureOpen();
        return this.docValuesProducer;
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        return this.core.knnVectorsReader;
    }

    @Override
    public FieldsProducer getPostingsReader() {
        this.ensureOpen();
        return this.core.fields;
    }

    public String toString() {
        return this.si.toString(this.si.info.maxDoc() - this.numDocs - this.si.getDelCount());
    }

    public String getSegmentName() {
        return this.si.info.name;
    }

    public SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public Directory directory() {
        return this.si.info.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyReaderClosedListeners() throws IOException {
        Set<IndexReader.ClosedListener> set = this.readerClosedListeners;
        synchronized (set) {
            IOUtils.applyToAll(this.readerClosedListeners, l -> l.onClose(this.readerCacheHelper.getKey()));
        }
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.readerCacheHelper;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.coreCacheHelper;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.metaData;
    }

    SegmentCommitInfo getOriginalSegmentInfo() {
        return this.originalSi;
    }

    public Bits getHardLiveDocs() {
        return this.hardLiveDocs;
    }

    @Override
    public void checkIntegrity() throws IOException {
        super.checkIntegrity();
        if (this.core.cfsReader != null) {
            this.core.cfsReader.checkIntegrity();
        }
    }

    static {
        TestSecrets.setSegmentReaderAccess(new SegmentReaderAccess(){

            @Override
            public Object getCore(SegmentReader segmentReader) {
                return segmentReader.core;
            }
        });
    }
}

