/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.extension.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public final class DifferenceRenderer {
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    static final double kError = 0.5;

    public static Fill[] createDifferenceFillFromPalette(Fill paletteEntry, boolean isColor) {
        ColorDefinition fillColorP = null;
        Fill fillColorN = null;
        if (paletteEntry instanceof ColorDefinition) {
            fillColorP = goFactory.copyOf((ColorDefinition)paletteEntry);
            fillColorN = goFactory.copyOf((ColorDefinition)paletteEntry);
        } else if (paletteEntry instanceof MultipleFill) {
            EList fills = ((MultipleFill)paletteEntry).getFills();
            fillColorP = goFactory.copyOf((Fill)fills.get(0));
            fillColorN = goFactory.copyOf((Fill)fills.get(1));
        } else if (isColor && paletteEntry instanceof Gradient) {
            fillColorP = goFactory.copyOf(((Gradient)paletteEntry).getStartColor());
            fillColorN = goFactory.copyOf(((Gradient)paletteEntry).getEndColor());
        } else {
            fillColorP = paletteEntry;
            fillColorN = paletteEntry;
        }
        return new Fill[]{fillColorP, fillColorN};
    }

    private static Fill[] createUpdateFills(AxesRenderer renderer, Fill paletteEntry) {
        Fill seriesPalette = DifferenceRenderer.getSeriesPaletteEntry(renderer);
        if (seriesPalette != null) {
            paletteEntry = seriesPalette;
        }
        Fill[] fills = DifferenceRenderer.createDifferenceFillFromPalette(paletteEntry, false);
        if (paletteEntry instanceof ColorDefinition) {
            fills[0] = renderer.getSeries().isSetTranslucent() && renderer.getSeries().isTranslucent() ? goFactory.translucent((ColorDefinition)paletteEntry) : goFactory.copyOf((ColorDefinition)paletteEntry);
            fills[1] = goFactory.copyOf((ColorDefinition)paletteEntry);
        }
        return fills;
    }

    public static void renderDifferencePolygon(AxesRenderer renderer, IPrimitiveRenderer ipr, DataPointHints[] dpha, Location[] loaP, Location[] loaN, LineAttributes liaP, LineAttributes liaN, Fill paletteEntry) {
        CPoint.bPrecise = false;
        if (loaP == null || loaN == null || loaP.length < 2 || loaN.length < 2) {
            return;
        }
        boolean isTransposed = ((ChartWithAxes)renderer.getModel()).isTransposed();
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)renderer.getSeries()), LineRenderEvent.class);
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)renderer.getSeries()), PolygonRenderEvent.class);
        DeferredCache dc = renderer.getDeferredCache();
        int findex = DifferenceRenderer.getFirstNonNullIndex(dpha);
        int lindex = DifferenceRenderer.getLastNonNullIndex(dpha);
        if (findex < 0 || lindex < 0) {
            return;
        }
        Fill[] fills = DifferenceRenderer.createUpdateFills(renderer, paletteEntry);
        Fill fillColorP = fills[0];
        Fill fillColorN = fills[1];
        CPointContainer points = new CPointContainer();
        CPoint pStart = new CPoint(loaP[findex].getX(), loaP[findex].getY(), isTransposed);
        CPoint nStart = new CPoint(loaN[findex].getX(), loaN[findex].getY(), isTransposed);
        int i = findex + 1;
        while (i <= lindex) {
            if (DifferenceRenderer.isValidDifferenceEntry(dpha[i].getOrthogonalValue())) {
                nStart.addToListBottom(points);
                pStart.addToList(points);
                CPoint pEnd = new CPoint(loaP[i].getX(), loaP[i].getY(), isTransposed);
                CPoint nEnd = new CPoint(loaN[i].getX(), loaN[i].getY(), isTransposed);
                CLine lp = new CLine(pStart, pEnd);
                CLine ln = new CLine(nStart, nEnd);
                DifferenceRenderer.renderLine(lp, lre, dc, liaP);
                DifferenceRenderer.renderLine(ln, lre, dc, liaN);
                CPoint intersection = lp.findIntersection(ln);
                if (intersection != null && !intersection.equals(lp.start) && !intersection.equals(ln.start)) {
                    intersection.addToList(points);
                    if (points.size() > 1) {
                        DifferenceRenderer.renderPolygon(points.getPoints(), pre, dc, pStart.compareY(nStart) >= 0.0 ? fillColorP : fillColorN, renderer.getSeries());
                        points.clear();
                        intersection.addToList(points);
                    }
                }
                if (i == lindex || i == dpha.length - 1) {
                    nEnd.addToListBottom(points);
                    pEnd.addToList(points);
                    if (points.size() > 1 && !DifferenceRenderer.locationEquals(loaP, loaN)) {
                        DifferenceRenderer.renderPolygon(points.getPoints(), pre, dc, pEnd.compareY(nEnd) >= 0.0 ? fillColorP : fillColorN, renderer.getSeries());
                    }
                    points.clear();
                    break;
                }
                pStart = pEnd;
                nStart = nEnd;
            }
            ++i;
        }
    }

    static void renderPolygon(List<CPoint> points, PolygonRenderEvent pre, DeferredCache dc, Fill fillColor, Series as) {
        Location[] pa = new Location[points.size()];
        Iterator<CPoint> it = points.iterator();
        int i = 0;
        while (it.hasNext()) {
            pa[i] = it.next().toLocation();
            ++i;
        }
        pre.setOutline(null);
        pre.setPoints(pa);
        pre.setBackground(fillColor);
        pre.setSourceObject((Object)StructureSource.createSeries((Series)as));
        dc.addPlane((PrimitiveRenderEvent)pre, 2);
    }

    static void renderLine(CLine line, LineRenderEvent lre, DeferredCache dc, LineAttributes lia) {
        if (lia.isVisible()) {
            lre.setStart(line.start.toLocation());
            lre.setEnd(line.end.toLocation());
            lre.setLineAttributes(lia);
            dc.addLine(lre);
        }
    }

    static Fill getSeriesPaletteEntry(AxesRenderer renderer) {
        int iThisSeriesIndex;
        Fill fPaletteEntry = null;
        SeriesDefinition sd = null;
        Series se = renderer.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se)) >= 0) {
            EList ePalette = sd.getSeriesPalette().getEntries();
            fPaletteEntry = FillUtil.getPaletteFill((EList)ePalette, (int)iThisSeriesIndex);
            renderer.updateTranslucency(fPaletteEntry, se);
        }
        return fPaletteEntry;
    }

    public static boolean isValidDifferenceEntry(Object obj) {
        DifferenceEntry entry;
        return obj instanceof DifferenceEntry && !Double.isNaN((entry = (DifferenceEntry)((Object)obj)).getPositiveValue()) && !Double.isNaN(entry.getNegativeValue());
    }

    static int getFirstNonNullIndex(DataPointHints[] dpha) {
        int i = 0;
        while (i < dpha.length) {
            if (DifferenceRenderer.isValidDifferenceEntry(dpha[i].getOrthogonalValue())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int getLastNonNullIndex(DataPointHints[] dpha) {
        int i = dpha.length - 1;
        while (i >= 0) {
            if (DifferenceRenderer.isValidDifferenceEntry(dpha[i].getOrthogonalValue())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static void renderDifferenceCurve(AxesRenderer renderer, IPrimitiveRenderer ipr, DataPointHints[] dpha, Location[] loaP, Location[] loaN, LineAttributes liaP, LineAttributes liaN, Fill paletteEntry) {
        CPoint nEnd;
        CPoint pEnd;
        CPoint.bPrecise = true;
        boolean bConnectingMissing = ((LineSeries)renderer.getSeries()).isConnectMissingValue();
        List listP = CurveRenderer.generateCurvePoints((BaseRenderer)renderer, (Location[])loaP, (boolean)bConnectingMissing, (double)0.0, (double)0.0);
        List listN = CurveRenderer.generateCurvePoints((BaseRenderer)renderer, (Location[])loaN, (boolean)bConnectingMissing, (double)0.0, (double)0.0);
        if (listP == null || listN == null || listP.size() < 2 || listN.size() < 2) {
            return;
        }
        int lengthP = listP.size();
        int lengthN = listN.size();
        boolean bTransposed = ((ChartWithAxes)renderer.getModel()).isTransposed();
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)renderer.getSeries()), LineRenderEvent.class);
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)renderer.getSeries()), PolygonRenderEvent.class);
        DeferredCache dc = renderer.getDeferredCache();
        Fill[] fills = DifferenceRenderer.createUpdateFills(renderer, paletteEntry);
        Fill fillColorP = fills[0];
        Fill fillColorN = fills[1];
        CPointContainer points = new CPointContainer();
        CPoint pStart = new CPoint((double[])listP.get(0), 0.5, bTransposed);
        CPoint nStart = new CPoint((double[])listN.get(0), 0.5, bTransposed);
        int i = 1;
        int j = 1;
        while (i < lengthP && j < lengthN) {
            pEnd = new CPoint((double[])listP.get(i), 0.5, bTransposed);
            nEnd = new CPoint((double[])listN.get(j), 0.5, bTransposed);
            CLine lineP = new CLine(pStart, pEnd);
            CLine lineN = new CLine(nStart, nEnd);
            if (nStart.compareX(pEnd) >= 0.0 || lineP.isVertical()) {
                ++i;
                pStart = pEnd;
                lineP.start.addToList(points);
                DifferenceRenderer.renderLine(lineP, lre, dc, liaP);
                continue;
            }
            if (pStart.compareX(nEnd) >= 0.0 || lineN.isVertical()) {
                ++j;
                nStart = nEnd;
                lineN.start.addToListBottom(points);
                DifferenceRenderer.renderLine(lineN, lre, dc, liaN);
                continue;
            }
            CPoint intersection = lineP.findIntersection(lineN);
            if (intersection == null) {
                lineN.start.addToListBottom(points);
                lineP.start.addToList(points);
            } else {
                intersection.addToList(points);
                DifferenceRenderer.renderPolygon(points.getPoints(), pre, dc, pStart.compareY(nStart) >= 0.0 ? fillColorP : fillColorN, renderer.getSeries());
                points.clear();
                intersection.addToList(points);
            }
            ++i;
            ++j;
            DifferenceRenderer.renderLine(lineP, lre, dc, liaP);
            DifferenceRenderer.renderLine(lineN, lre, dc, liaN);
            pStart = pEnd;
            nStart = nEnd;
        }
        while (i <= lengthP) {
            pEnd = new CPoint((double[])listP.get(i - 1), 0.5, bTransposed);
            pEnd.addToList(points);
            DifferenceRenderer.renderLine(new CLine(pStart, pEnd), lre, dc, liaP);
            ++i;
            pStart = pEnd;
        }
        while (j <= lengthN) {
            nEnd = new CPoint((double[])listN.get(j - 1), 0.5, bTransposed);
            nEnd.addToListBottom(points);
            DifferenceRenderer.renderLine(new CLine(nStart, nEnd), lre, dc, liaN);
            ++j;
            nStart = nEnd;
        }
        if (points.size() > 2) {
            if (!DifferenceRenderer.locationEquals(loaP, loaN)) {
                DifferenceRenderer.renderPolygon(points.getPoints(), pre, dc, pStart.compareY(nStart) >= 0.0 ? fillColorP : fillColorN, renderer.getSeries());
            }
            points.clear();
        }
    }

    private static boolean locationEquals(Location[] loaP, Location[] loaN) {
        if (loaP.length != loaN.length) {
            return false;
        }
        int i = 0;
        while (i < loaP.length) {
            if (loaP[i].getX() != loaN[i].getX() || loaP[i].getY() != loaN[i].getY()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static class CLine {
        public transient CPoint start;
        public transient CPoint end;

        public CLine(CPoint start, CPoint end) {
            this.start = start;
            this.end = end;
        }

        public double getSlope() {
            if (this.isVertical()) {
                return Double.NaN;
            }
            return (this.end.y - this.start.y) / (this.end.x - this.start.x);
        }

        public boolean isVertical() {
            return CPoint.bPrecise ? this.start.x == this.end.x : ChartUtil.mathEqual((double)this.start.x, (double)this.end.x);
        }

        boolean checkBoundOfPoint(CPoint point) {
            boolean b = ChartUtil.mathLT((double)this.start.x, (double)this.end.x) ? ChartUtil.mathGE((double)point.x, (double)this.start.x) && ChartUtil.mathLE((double)point.x, (double)this.end.x) : ChartUtil.mathLE((double)point.x, (double)this.start.x) && ChartUtil.mathGE((double)point.x, (double)this.end.x);
            return b;
        }

        public CPoint findIntersection(CLine line) {
            double k2;
            if (this.isVertical() || line.isVertical()) {
                return null;
            }
            double k1 = this.getSlope();
            if (k1 == (k2 = line.getSlope())) {
                if (this.end.equals(line.start)) {
                    return this.end;
                }
                if (this.start.equals(line.end)) {
                    return this.start;
                }
                return null;
            }
            double pointX = (line.start.y - this.start.y + k1 * this.start.x - k2 * line.start.x) / (k1 - k2);
            double pointY = k1 * (pointX - this.start.x) + this.start.y;
            CPoint intersection = null;
            intersection = this.start.bTransposed ? new CPoint(pointY, pointX, this.start.bTransposed) : new CPoint(pointX, pointY, this.start.bTransposed);
            if (!this.checkBoundOfPoint(intersection) && !line.checkBoundOfPoint(intersection)) {
                return null;
            }
            return intersection;
        }

        public String toString() {
            return "Start point:" + this.start + " End point:" + this.end;
        }
    }

    static class CPoint {
        public transient double x;
        public transient double y;
        public transient boolean bTransposed = false;
        public static transient boolean bPrecise = false;

        public CPoint(double x, double y, boolean bTransposed) {
            this.bTransposed = bTransposed;
            if (bTransposed) {
                this.y = x;
                this.x = y;
            } else {
                this.x = x;
                this.y = y;
            }
        }

        public CPoint(double[] point, double offset, boolean bTransposed) {
            this(point[0] + offset, point[1] + offset, bTransposed);
        }

        public Location toLocation() {
            return this.bTransposed ? goFactory.createLocation(this.y, this.x) : goFactory.createLocation(this.x, this.y);
        }

        public void addToListBottom(CPointContainer points) {
            if (!points.contains(this)) {
                points.addFirst(this);
            }
        }

        public void addToList(CPointContainer points) {
            if (!points.contains(this)) {
                points.add(this);
            }
        }

        public String toString() {
            return "b=" + this.bTransposed + " x=" + ChartUtil.formatDouble((double)this.x) + " y=" + ChartUtil.formatDouble((double)this.y);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CPoint) {
                CPoint p = (CPoint)obj;
                if (bPrecise) {
                    return this.x == p.x && this.y == p.y && this.bTransposed == p.bTransposed;
                }
                return ChartUtil.mathEqual((double)this.x, (double)p.x) && ChartUtil.mathEqual((double)this.y, (double)p.y) && this.bTransposed == p.bTransposed;
            }
            return false;
        }

        public int hashCode() {
            return Double.valueOf(this.x).hashCode() ^ 37 * Double.valueOf(this.y).hashCode() ^ Boolean.valueOf(this.bTransposed).hashCode();
        }

        public double compareX(CPoint p) {
            return this.bTransposed ? p.x - this.x : this.x - p.x;
        }

        public double compareY(CPoint p) {
            return this.bTransposed ? this.y - p.y : p.y - this.y;
        }
    }

    static class CPointContainer {
        private final HashSet<String> set = new HashSet();
        private final LinkedList<CPoint> list = new LinkedList();

        CPointContainer() {
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.set.clear();
            this.list.clear();
        }

        public boolean contains(CPoint o) {
            return this.set.contains(o.toString());
        }

        public void add(CPoint o) {
            this.set.add(o.toString());
            this.list.add(o);
        }

        public void addFirst(CPoint o) {
            this.set.add(o.toString());
            this.list.addFirst(o);
        }

        public List<CPoint> getPoints() {
            return this.list;
        }
    }
}

