/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class IndexedJvmTypeAccess {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet) {
        URI withoutFragment;
        String fqn;
        String[] fqnSegments;
        QualifiedName qualifiedName;
        Iterable candidates;
        Iterator iterator;
        IResourceDescriptions descriptions;
        if (resourceSet != null && (descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet)) != null && (iterator = (candidates = descriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName = QualifiedName.create((String[])(fqnSegments = (fqn = (withoutFragment = javaObjectURI.trimFragment()).segment(withoutFragment.segmentCount() - 1)).split("\\."))), false)).iterator()).hasNext()) {
            EObject result;
            IEObjectDescription description = (IEObjectDescription)iterator.next();
            EObject typeProxy = description.getEObjectOrProxy();
            if (typeProxy.eIsProxy()) {
                typeProxy = EcoreUtil.resolve((EObject)typeProxy, (ResourceSet)resourceSet);
            }
            if (!typeProxy.eIsProxy() && typeProxy instanceof JvmType && (result = this.resolveJavaObject((JvmType)typeProxy, javaObjectURI.fragment())) != null) {
                return result;
            }
        }
        return null;
    }

    public EObject resolveJavaObject(JvmType rootType, String fragment) {
        block9: {
            int dot;
            int dollar;
            String subFragment;
            EObject container;
            block8: {
                if (fragment.endsWith("[]")) {
                    return this.resolveJavaArrayObject(rootType, fragment);
                }
                int slash = fragment.indexOf(47);
                if (slash == -1) break block8;
                if (slash == 0) {
                    return null;
                }
                String containerFragment = fragment.substring(0, slash);
                EObject container2 = this.resolveJavaObject(rootType, containerFragment);
                if (container2 == null) break block9;
                String parameterName = fragment.substring(slash + 1);
                if (container2 instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container2;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
                break block9;
            }
            if (rootType.getIdentifier().equals(fragment)) {
                return rootType;
            }
            int paren = fragment.indexOf(40);
            if (paren == -1) {
                paren = fragment.length();
            }
            if ((container = this.resolveJavaObject(rootType, subFragment = fragment.substring(0, Math.max(dollar = fragment.lastIndexOf(36, paren), dot = fragment.lastIndexOf(46, paren))))) instanceof JvmDeclaredType) {
                EList<JvmMember> members = ((JvmDeclaredType)container).getMembers();
                for (JvmMember member : members) {
                    String name = member.getIdentifier();
                    if (!name.equals(fragment)) continue;
                    return member;
                }
            }
        }
        return null;
    }

    public EObject resolveJavaArrayObject(JvmType rootType, String fragment) {
        JvmComponentType component = (JvmComponentType)this.resolveJavaObject(rootType, fragment.substring(0, fragment.length() - 2));
        if (component == null) {
            return null;
        }
        if (component.getArrayType() == null) {
            JvmArrayType arrayType = TypesFactory.eINSTANCE.createJvmArrayType();
            arrayType.setComponentType(component);
        }
        return component.getArrayType();
    }
}

