/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.xbase.XbaseRuntimeModule;
import org.eclipse.xtext.xbase.XtypeRuntimeModule;
import org.eclipse.xtext.xbase.annotations.XbaseWithAnnotationsRuntimeModule;
import org.eclipse.xtext.xbase.annotations.ui.XbaseWithAnnotationsUiModule;
import org.eclipse.xtext.xbase.ui.XbaseUiModule;
import org.eclipse.xtext.xbase.ui.XtypeUiModule;
import org.osgi.framework.BundleContext;

public class XtypeActivator
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(XtypeActivator.class);
    private Cache<String, Injector> injectors = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Injector>(){

        public Injector load(String language) throws Exception {
            Module runtimeModule = XtypeActivator.this.getRuntimeModule(language);
            Module sharedStateModule = XtypeActivator.this.getSharedStateModule();
            Module uiModule = XtypeActivator.this.getUiModule(language);
            Module mergedModule = Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{runtimeModule}).with(new Module[]{sharedStateModule})}).with(new Module[]{uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
    });
    private static XtypeActivator INSTANCE;
    public static final String ORG_ECLIPSE_XTEXT_XBASE_XTYPE = "org.eclipse.xtext.xbase.Xtype";
    public static final String ORG_ECLIPSE_XTEXT_XBASE_XBASE = "org.eclipse.xtext.xbase.Xbase";
    public static final String ORG_ECLIPSE_XTEXT_XBASE_ANNOTATIONS_XBASEWITHANNOTATIONS = "org.eclipse.xtext.xbase.annotations.XbaseWithAnnotations";

    public Injector getInjector(String languageName) {
        try {
            return (Injector)this.injectors.get((Object)languageName);
        }
        catch (ExecutionException e) {
            logger.error((Object)("Failed to create injector for " + languageName));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to create injector for " + languageName, e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.injectors.invalidateAll();
        this.injectors.cleanUp();
        INSTANCE = null;
        super.stop(context);
    }

    public static XtypeActivator getInstance() {
        return INSTANCE;
    }

    protected Module getRuntimeModule(String grammar) {
        if (ORG_ECLIPSE_XTEXT_XBASE_XTYPE.equals(grammar)) {
            return new XtypeRuntimeModule();
        }
        if (ORG_ECLIPSE_XTEXT_XBASE_XBASE.equals(grammar)) {
            return new XbaseRuntimeModule();
        }
        if (ORG_ECLIPSE_XTEXT_XBASE_ANNOTATIONS_XBASEWITHANNOTATIONS.equals(grammar)) {
            return new XbaseWithAnnotationsRuntimeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if (ORG_ECLIPSE_XTEXT_XBASE_XTYPE.equals(grammar)) {
            return new XtypeUiModule(this);
        }
        if (ORG_ECLIPSE_XTEXT_XBASE_XBASE.equals(grammar)) {
            return new XbaseUiModule(this);
        }
        if (ORG_ECLIPSE_XTEXT_XBASE_ANNOTATIONS_XBASEWITHANNOTATIONS.equals(grammar)) {
            return new XbaseWithAnnotationsUiModule(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

