/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.navigation;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.builder.navigation.IDerivedMemberAwareEditorOpener;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class DerivedMemberAwareEditorOpener
extends LanguageSpecificURIEditorOpener
implements IDerivedMemberAwareEditorOpener {
    @Inject
    private IJvmModelAssociations associations;

    public IEditorPart open(URI uri, IMember member, boolean select) {
        if (member != null) {
            URI memberURI = new TypeURIHelper().getFullURI((IJavaElement)member);
            String identifier = memberURI.fragment();
            URI uriWithQuery = uri.appendQuery(identifier);
            super.open(uriWithQuery, select);
        }
        return this.open(uri, select);
    }

    protected EObject findEObjectByURI(URI uri, XtextResource resource) {
        if (uri.query() != null) {
            String identifier = uri.query();
            TreeIterator contents = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
            while (contents.hasNext()) {
                String identifierFromResource;
                EObject content = (EObject)contents.next();
                if (!(content instanceof JvmIdentifiableElement) || !identifier.equals(identifierFromResource = ((JvmIdentifiableElement)content).getIdentifier())) continue;
                EObject sourceElement = this.associations.getPrimarySourceElement(content);
                return sourceElement;
            }
        }
        return super.findEObjectByURI(uri, resource);
    }
}

