/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class RefactoringResourceSetProvider {
    @Inject
    private IExternalContentSupport externalContentSupport;
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IResourceSetProvider delegate;

    public ResourceSet get(IProject project) {
        ResourceSet resourceSet = this.delegate.get(project);
        this.configure(resourceSet);
        return resourceSet;
    }

    protected void configure(ResourceSet resourceSet) {
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.LIVE_SCOPE", Boolean.TRUE);
        if (resourceSet instanceof ResourceSetImpl) {
            ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
        }
        this.externalContentSupport.configureResourceSet(resourceSet, this.dirtyStateManager.getActualContentProvider());
    }
}

